//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
texture texture0;
float    time;
float g_Radius=0.005;
float lumFactor=1.0;
float lumOffset=0.0;

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
sampler tex0 = 
sampler_state
{
    Texture = <texture0>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float2 TextureUV  : TEXCOORD0;  // vertex texture coords 
};


//--------------------------------------------------------------------------------------
// This shader computes standard transform and lighting
//--------------------------------------------------------------------------------------
VS_OUTPUT RenderSceneVS( float4 vPos : POSITION, 
                         float2 vTexCoord0 : TEXCOORD0 )
{
    VS_OUTPUT Output;
  
    Output.Position = vPos;
    Output.TextureUV=vTexCoord0;   
    return Output;    
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
PS_OUTPUT RenderScenePS( VS_OUTPUT In ) 
{ 
    PS_OUTPUT Output;

	float col=0.0;
	float xOff[]={0.104156970977783, 0.126504063606262, 0.893619418144226, -0.0300261974334717, -0.45546966791153, 0.058881402015686, 0.933382153511047, 0.426024436950684, 0.188897490501404, -0.743360996246338, -0.670918226242065, 0.826021075248718, 0.749026656150818, -0.519942939281464, -0.884692490100861, 0.890323996543884, -0.229331910610199, -0.700659871101379, 0.309456348419189, -0.611573696136475, 0.841279268264771, -0.808311283588409, -0.604207277297974, 0.1638103723526, 0.920200943946838};
	float yOff[]={0.714210152626038, -0.283464252948761, -0.758965194225311, -0.88322502374649, -0.528491616249084, 0.502647042274475, 0.389225125312805, 0.315292835235596, -0.546858131885529, 0.887423753738403, 0.0365505218505859, 0.994515538215637, 0.521982073783875, 0.597830891609192, -0.99372798204422, -0.469760537147522, 0.0792911052703857, -0.0817093849182129, -0.428913354873657, -0.113744080066681, -0.903767466545105, -0.86942982673645, -0.964410245418549, -0.293683350086212, -0.106071054935455};
	float radius=tex2D(tex0, In.TextureUV).r*g_Radius;
	float2 uv=(float2)0;
	
	for (int i=0; i<9; i++) {
		uv.x=In.TextureUV.x*0.5+radius*xOff[i];
		uv.y=In.TextureUV.y*0.5+radius*yOff[i];
		col+=tex2D(tex0, uv).g;
	}

	col=col/6.0*lumFactor+lumOffset;
    Output.RGBColor.r=saturate(col-0.3);
    Output.RGBColor.g=saturate(col);
    Output.RGBColor.b=saturate(col-0.1);
    Output.RGBColor.a=1.0;

    return Output;
}


//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique tester
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS( );
        PixelShader  = compile ps_2_0 RenderScenePS( );
    }
}
