uniform sampler2D distortionSampler;
uniform sampler2D opacitySampler;
uniform sampler2D baseSampler;

uniform vec3 distortionAmount;
uniform vec4 heightAttenuation;

varying vec2  texCoord0;
varying vec2  distCoord1;
varying vec2  distCoord2;
varying vec2  distCoord3;

vec4 translateVectorZeroOneIntervalToUnitInterval(vec4 x)
{
   vec4 retVal =x;
   retVal = (2.0 * x) - 1.0;
   return retVal;
}

void main(void)
{
   vec4 noise0;
   vec4 noise1;
   vec4 noise2;

   noise0 = texture2D(distortionSampler, distCoord1);
   noise1 = texture2D(distortionSampler, distCoord2);
   noise2 = texture2D(distortionSampler, distCoord3);

   vec4 noiseSummed = translateVectorZeroOneIntervalToUnitInterval(noise0) * distortionAmount.x + 
                   translateVectorZeroOneIntervalToUnitInterval(noise1) * distortionAmount.y + 
                   translateVectorZeroOneIntervalToUnitInterval(noise2) * distortionAmount.z;

   vec2 perturbedBaseCoords = texCoord0 + noiseSummed.xy * ( (texCoord0.y) * heightAttenuation.x + heightAttenuation.y);

   vec4 base    = texture2D(baseSampler,    perturbedBaseCoords);
   vec4 opacity = texture2D(opacitySampler, perturbedBaseCoords);

   gl_FragColor =  base * vec4(opacity.xyz, opacity.x);
}