
// uniform sampler1D xtable;
// uniform sampler1D ytable;

uniform sampler2D   normalmap;
uniform samplerCube lightmap;

uniform vec3 refract_translate;

varying vec3 v_refract_incoming;
varying vec3 color;

const vec3 vecz = vec3(0.0,0.0,1.0);
const vec3 mirror = vec3(-1.0, -1.0, +1.0);

const vec3 csalas = vec3(0.0,0.0,0.85);

const float eta     = 1.45;
const float reta    = 1.0 / eta;
const float etasqr  = eta * eta;
const float retasqr = reta * reta;

void main()
{ vec3 n, i, r, s;
  float c1,c2;

  n =  /* normalize */ ( -1.0 + 2.0 * texture2D ( normalmap , gl_TexCoord[0].xy ).xyz );
  i = normalize ( v_refract_incoming ); 

//  r = refract ( n    , -i , eta   );
//  s = refract ( vecz , normalize(r) , reta );

  c1 = dot(i,n);    // ez legyen pozitiv!
  if (c1<0.0)
  { n -= 2.0*c1*i; 
    c1 = -c1; //dot(i,n);
  }
  c2 = sqrt(1.0 - (1.0-c1*c1) * retasqr);
  r =  /* normalize */ ( reta*i - (reta*c1-c2)*n ); 
  
  c1 = dot(r,vecz);    // ez legyen pozitiv. legyen? de hat ez azt hiszem mindig pozitiv.
  c2 = (1.0 - (1.0-c1*c1) * etasqr);
  if (c2 >= 0.0)
  { c2 = sqrt(c2);
    s = eta*r - (eta*c1-c2)*vecz; 
  }
  else
  { s = -vecz; 
  }
  
  s.xy += 1.4 * i.xy;
  gl_FragColor.rgb = textureCube ( lightmap, s ) . rgb * color; // * (length(r) * length(s)); 
  
}


