
uniform vec3  lights[3];
uniform vec3  colors[3];
uniform float falloff[3];
uniform vec3  ambient;

// uniform int nlights;

varying vec3 coord;
varying vec3 normal;

// -------------

uniform vec2 screencenter;
uniform float minalpha;
uniform float radius1;
uniform float radius2;
uniform float oneoverradiusdifference;

void thehole(vec3 color)
{ 
  float alpha;

  alpha = clamp ( length( gl_FragCoord.xy - screencenter), radius1, radius2 );
  alpha = ( alpha - radius1 ) * oneoverradiusdifference;
  alpha = minalpha + (1.0 - minalpha) * alpha; // pow( alpha , 0.6 ) ; 

  gl_FragColor = vec4( color , alpha );
}

// -------------

vec3 light3()
{
  vec3 u,c,n;
  float x; 
  n = normalize(normal);
   
  u = lights[0] - coord; x = max ( 0.0 , dot( u , n ) / length(u) ) ; c  = pow(x,falloff[0]) * colors[0];  
  u = lights[1] - coord; x = max ( 0.0 , dot( u , n ) / length(u) ) ; c += pow(x,falloff[1]) * colors[1];  
  u = lights[2] - coord; x = max ( 0.0 , dot( u , n ) / length(u) ) ; c += pow(x,falloff[2]) * colors[2];  
  return (c + ambient);
}

void main()
{
  thehole ( light3() );
} 


