
#version 100

// lehetne esetleg parhuzamositani az egeszet
// a loopot negyedakkora loopra
// es a refmap egyelore ugye nem refmap, csak normal-lookup

#define MAX 8  // vec2+float+vec3=6 ; 6*MAX=48 < 64, ugyhogy meg okesak vagyunk. 64 a minmax uniform / fsh.

uniform int   n;             // number of blobs
uniform vec2  centers[MAX];  // the centers
uniform float radiisqr[MAX]; // squares of the radii
//uniform vec3  colors[MAX];   // the colors
uniform float critical;      // critical value (between 0 and 1)
                             // nagyobb -> szebb, de kisebb blobok

//uniform vec3 col1;
//uniform samplerCube refmap;

varying vec2 v_blob_xy;      // mert a geometriat torzithatjuk kedvunkre

// a blobfuggvenyunk, kizarasos alapon, az lesz hogy 
// f(x,y,z;r) = ( 1 - (x^2+y^2+z^2)/r^2 ) ^2
// ugyanis meg kell oldani fix x[i],y[i],r[i]-re es ismeretlen z-re azt az egyenletet, hogy
// sum_i f ( x[i], y[i], z ; r[i] ) = c
// es ilyen f-re ez masodfoku w=z^2-ben
// s[i] = x[i]^2 + y[i]^2

void main()
{
  int i;
  vec2 u;
  vec3 v,nv;
  float b,r,q,q2;
  float k,s1q,s1q2,s2q2,sq,sq2;
  float nsq4,nq4;
  float b1,c1,d1,w,w1;
  float tmp1;

//  gl_FragColor.rgb = col1; //vec3(0.8,0.4,0.6);
//  gl_FragColor.r = v_blob_xy.x;

  k=0.0; s1q=0.0; s1q2=0.0; s2q2=0.0; sq=0.0; sq2=0.0; 
  nsq4=0.0; nq4=0.0; // leendo normalvektorokhoz

  for(i=0;i<2;i++)
  { u = v_blob_xy - centers[i];
    b = dot(u,u);
    r = radiisqr[i];    
    if (b<=r) 
    { 
      q = 1.0/r;      // 1/r^2
      q2 = q*q;       // 1/r^4
     
      tmp1 = b*q2;    // ( x^2 + y^2 ) / r^4
      
      k++;            // # points
      s1q  += b*q;    //          sum ( x^2 + y^2 )   / r^2
      s1q2 += tmp1;   // b*q2;    sum ( x^2 + y^2 )   / r^4
      s2q2 += b*tmp1; // b*b*q2;  sum ( x^2 + y^2 )^2 / r^4
      sq   += q;      //          sum ( 1/r^2 )
      sq2  += q2;     //          sum ( 1/r^4 ) = A
      
      //nq4  += q2*q2;          //  sum ( 1/r^8 )
      //nsq4 += (1.0-tmp1)*q2;  //  sum ( 1 - ( x^2 + y^2 ) / r^4 ) / r^4 
    }
  } 

  if (k>0.5)  
  {
  
    // a1 = sq2;  
    b1 = - s1q2 + sq;       // -1/2 -szer a szokasos b a masodfoku megoldokepletben
    c1 = k + s2q2 - s1q - s1q - critical;
   
    d1 = b1*b1 - sq2*c1;  // diszkriminans1; elvileg soha se lehet negativ de pontatlan.
    
    if (d1<0.0)
    { w1 = b1 + sqrt(d1);     // w1 = z^2 * (sum 1/r[i]^4)  
    }
    else
    { w1 = b1 + sqrt(d1);
    } 
    w = w1/sq2;  // masodfoku egyenlet megoldokeplete, csak atcsoportositottuk a 2-est
    
    // w = z^2
    if (w>=0.0)
    {
      v.xy = v_blob_xy;
      v.z = sqrt(w);          // a vektor
  
      //tmp1 = (-4.0) * ( nsq4 + nq4*w );
      //nv = tmp1 * v; 
      gl_FragColor.rgb = vec3(v.z,v.z,v.z); //nv;
      //gl_FragColor = textureCube(refmap,nv);
    }
    else gl_FragColor.rgb = vec3(0.3,0.9,0.6);
  }
  else
  { //discard;
    gl_FragColor.rgb = vec3(0.8,0.4,0.6);
  }
  
}  

