	varying vec4 diffuse,ambientGlobal,ambient;
	varying vec3 normal,lightDir,halfVector;
	varying float dist;
	uniform int meshdeform;
	uniform float time;
	uniform float deformv;


	vec4 DoTwist( vec4 pos, float t )
	{
		float st = sin(t);
		float ct = cos(t);
		vec4 new_pos;
		
		new_pos.x = pos.x*ct - pos.z*st;
		new_pos.z = pos.x*st + pos.z*ct;
		
		new_pos.y = pos.y;
		new_pos.w = pos.w;

		return( new_pos );
	}

	void main()
	{	
		vec4 ecPos;
		vec3 aux;
		int uselight=1;
		
		normal = normalize(gl_NormalMatrix * gl_Normal);
		
		/* these are the new lines of code to compute the light's direction */
		ecPos = gl_ModelViewMatrix * gl_Vertex;
		aux = vec3(gl_LightSource[uselight].position-ecPos);
		lightDir = normalize(aux);
		dist = length(aux);
	
		halfVector = normalize(gl_LightSource[uselight].halfVector.xyz);
		
		/* Compute the diffuse, ambient and globalAmbient terms */
		diffuse = gl_FrontMaterial.diffuse * gl_LightSource[uselight].diffuse;
		
		/* The ambient terms have been separated since one of them */
		/* suffers attenuation */
		ambient = gl_FrontMaterial.ambient * gl_LightSource[uselight].ambient;
		ambientGlobal = gl_LightModel.ambient * gl_FrontMaterial.ambient;
		
			
		//gl_Position = ftransform();

		
		///////////////////////////////////////////////////////////////
		//	envmap...
		
		gl_TexCoord[0] = gl_MultiTexCoord0;

		vec3 u = normalize( vec3(gl_ModelViewMatrix * gl_Vertex) );
		vec3 n = normalize( gl_NormalMatrix * gl_Normal );
		vec3 r = reflect( u, n );
		float m = 2.0 * sqrt( r.x*r.x + r.y*r.y + (r.z+1.0)*(r.z+1.0) );
		gl_TexCoord[1].s = r.x/m + 0.5;
		gl_TexCoord[1].t = r.y/m + 0.5;

		////////////////////////////////////////////////////////////////7
		// mesh distorts...
		
		vec4 twistedPosition = gl_Vertex;//DoTwist(gl_Vertex, ang);
		
		// total distort
		if(meshdeform==2)
		{
			twistedPosition.x=sin(twistedPosition.x*0.2+time*02.2)*deformv*twistedPosition.z;
		}
		
		// sinusschwabbel
		if(meshdeform==1)
		{
			twistedPosition.x=(sin(twistedPosition.x*0.02+time*02.2)*1*twistedPosition.x)*deformv+twistedPosition.x;
			twistedPosition.z=(sin(twistedPosition.z*0.02+time*02.2)*1*twistedPosition.x)*deformv+twistedPosition.z;
			twistedPosition.y=(sin(twistedPosition.y*0.02+time*02.2)*1*twistedPosition.x)*deformv+twistedPosition.y;
		}
		 
		gl_Position = gl_ModelViewProjectionMatrix * twistedPosition;
	
	
		
		
	} 