/*
 * Decompiled with CFR 0.152.
 */
package vsysTypes;

import help.help;
import java.util.Arrays;
import java.util.Comparator;
import opengl.common;
import vsysTypes.vInt;
import vsysTypes.vKeyFramedType;
import vsysTypes.vKeyframed;

public class vKFInt
extends vKeyframed
implements vKeyFramedType {
    public static String classSimpleName = "vKFInt";
    boolean waschanged = false;
    private boolean loop = false;
    public vInt[] keyframes = new vInt[1];
    private int currentkey = 0;
    public String[] valueTitles = null;

    @Override
    public void removeAt(float f) {
        this.move(f, 9999999.0f);
        if (this.keyframes.length != 1) {
            this.keyframes = (vInt[])help.resizeArray(this.keyframes, this.keyframes.length - 1);
        }
    }

    @Override
    public void addKey(float t, float v) {
        this.change(t, (int)v);
    }

    @Override
    public boolean getChanged() {
        boolean w = this.waschanged;
        this.waschanged = false;
        return w;
    }

    @Override
    public Object[] getKeys() {
        return this.keyframes;
    }

    public vKFInt() {
        this.keyframes[0] = new vInt(0.0f, 0);
    }

    @Override
    public void addKey(float t) {
        this.waschanged = true;
        this.change(t, 1);
    }

    public void setValue(int i) {
        this.waschanged = true;
        this.change(common.currentTime, i);
    }

    public void change(vInt k) {
        this.change(k.time, k.value);
    }

    public void sortKeys() {
        Arrays.sort(this.keyframes, new Comparator(){

            public int compare(Object a, Object b) {
                vInt ia = (vInt)a;
                vInt ib = (vInt)b;
                if (ia.time > ib.time) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void change(float t, int v) {
        if (!this.keyframed) {
            this.keyframes[0].value = v;
        } else {
            boolean found = false;
            int i = 0;
            while (i < this.keyframes.length) {
                if (t == this.keyframes[i].time) {
                    this.keyframes[i].value = v;
                    found = true;
                }
                ++i;
            }
            if (!found) {
                System.out.println("key not found...");
                this.keyframes = (vInt[])help.resizeArray(this.keyframes, this.keyframes.length + 1);
                this.keyframes[this.keyframes.length - 1] = new vInt(t, v);
            }
            this.sortKeys();
        }
    }

    public int getKeyframedValue() {
        return this.getValue(common.currentTime);
    }

    @Override
    public void move(float t, float t2) {
        int i = 0;
        while (i < this.keyframes.length) {
            if (t == this.keyframes[i].time) {
                this.keyframes[i].time = t2;
                break;
            }
            ++i;
        }
        this.sortKeys();
    }

    public int getCurrentkey() {
        return this.currentkey;
    }

    public int getValue(float time) {
        int ret = 0;
        if (!this.keyframed) {
            ret = this.keyframes[0].value;
            this.currentkey = 0;
        } else if (this.interPolationType == INTERPOLATION_LINEAR) {
            if (this.keyframes.length == 1) {
                this.currentkey = 0;
                return this.keyframes[0].value;
            }
            int which = -1;
            int i = 0;
            while (i < this.keyframes.length) {
                if (this.keyframes[i].time <= time) {
                    which = i;
                }
                ++i;
            }
            if (which == -1 || which == this.keyframes.length - 1) {
                this.currentkey = this.keyframes.length - 1;
                return this.keyframes[this.keyframes.length - 1].value;
            }
            int next = which + 1;
            float r = (time - this.keyframes[which].time) / (this.keyframes[next].time - this.keyframes[which].time);
            ret = this.keyframes[which].value + (int)(r * (float)(this.keyframes[next].value - this.keyframes[which].value));
            this.currentkey = which;
        } else if (this.interPolationType == INTERPOLATION_ABSOLUTE) {
            int which = -1;
            int i = 0;
            while (i < this.keyframes.length) {
                if (time >= this.keyframes[i].time) {
                    which = i;
                    ret = this.keyframes[i].value;
                    this.currentkey = i;
                }
                ++i;
            }
            if (which == -1) {
                this.currentkey = 0;
                return this.keyframes[0].value;
            }
        }
        return ret;
    }

    public void setValueTitles(String[] s) {
        this.valueTitles = s;
    }
}

