/*
 * Decompiled with CFR 0.152.
 */
package vsysTypes;

import common.keyframe;
import help.help;
import java.util.Arrays;
import java.util.Comparator;
import opengl.common;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vsysTypes.vFloat;
import vsysTypes.vKeyFramedType;
import vsysTypes.vKeyframed;

public class vKFFloat
extends vKeyframed
implements vKeyFramedType {
    public static String classSimpleName = "vKFFloat";
    boolean changed = false;
    private boolean loop = false;
    public int currentkey = 0;
    public vFloat[] keyframes = new vFloat[1];
    public float timelength = 0.0f;

    public vKFFloat() {
        this.keyframes[0] = new vFloat(0.0f, 0.0f);
    }

    @Override
    public void addKey(float t, float v) {
        this.change(t, v);
    }

    @Override
    public boolean getChanged() {
        boolean r = this.changed;
        r = this.changed;
        this.changed = false;
        return r;
    }

    @Override
    public void removeAt(float f) {
        this.move(f, 9999999.0f);
        this.keyframes = (vFloat[])help.resizeArray(this.keyframes, this.keyframes.length - 1);
        if (this.keyframes.length == 0) {
            this.change(0.0f, 0.0f);
        }
    }

    @Override
    public void move(float t, float t2) {
        int i = 0;
        while (i < this.keyframes.length) {
            if (t == this.keyframes[i].time) {
                this.keyframes[i].time = t2;
                break;
            }
            ++i;
        }
        this.sortKeys();
    }

    public void sortKeys() {
        Arrays.sort(this.keyframes, new Comparator(){

            public int compare(Object a, Object b) {
                vFloat ia = (vFloat)a;
                vFloat ib = (vFloat)b;
                if (ia.time > ib.time) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public Object[] getKeys() {
        return this.keyframes;
    }

    public void setValue(float f) {
        this.change(common.currentTime, f);
        this.changed = true;
    }

    @Override
    public void addKey(float v) {
        this.change(common.currentTime, v);
        this.changed = true;
    }

    public void change(keyframe f) {
        this.change(f.time, f.value);
        this.changed = true;
    }

    public void change(float time, float value) {
        this.changed = true;
        if (!this.keyframed) {
            this.keyframes[0].value = value;
        } else {
            if (time > this.timelength) {
                this.timelength = time;
            }
            if (this.keyframes != null) {
                int which = this.keyframes.length;
                boolean alldone = false;
                int i = 0;
                while (i < this.keyframes.length) {
                    if (this.keyframes[i].time == time) {
                        this.keyframes[i].value = value;
                        alldone = true;
                    }
                    if (time < this.keyframes[i].time) {
                        which = i;
                    }
                    ++i;
                }
                if (!alldone) {
                    this.keyframes = (vFloat[])help.resizeArray(this.keyframes, this.keyframes.length + 1);
                    this.keyframes[this.keyframes.length - 1] = new vFloat(time, value);
                }
                this.sortKeys();
            } else {
                help.resizeArray(this.keyframes, 1);
                this.keyframes[0] = new vFloat(time, value);
            }
        }
    }

    public void setloop(boolean l) {
        this.loop = l;
    }

    public float getValue() {
        return this.getValue(common.currentTime);
    }

    public float getKeyframedFloatValue() {
        return this.getValue(common.currentTime);
    }

    public float getValue(float time) {
        float val = -1.0f;
        if (!this.keyframed) {
            val = this.keyframes[0].value;
        } else {
            if (this.interPolationType == INTERPOLATION_ABSOLUTE) {
                int which = 0;
                int i = 0;
                while (i < this.keyframes.length) {
                    if (this.keyframes[i].time <= time) {
                        which = i;
                    }
                    ++i;
                }
                return this.keyframes[which].value;
            }
            if (this.interPolationType == INTERPOLATION_LINEAR) {
                if (this.keyframes.length == 1) {
                    return this.keyframes[0].value;
                }
                if (this.loop && time >= this.keyframes[this.keyframes.length - 1].time) {
                    while (time > this.timelength) {
                        time -= this.timelength;
                    }
                }
                int which = -1;
                int i = 0;
                while (i < this.keyframes.length) {
                    if (this.keyframes[i].time <= time) {
                        which = i;
                    }
                    ++i;
                }
                if (which == -1 || which == this.keyframes.length - 1) {
                    return this.keyframes[this.keyframes.length - 1].value;
                }
                int next = which + 1;
                val = (time - this.keyframes[which].time) / (this.keyframes[next].time - this.keyframes[which].time);
                val = this.keyframes[which].value + val * (this.keyframes[next].value - this.keyframes[which].value);
            }
        }
        return val;
    }

    public vFloat get(int which) {
        return this.keyframes[which];
    }

    public void remove(int which) {
    }

    public Element saveXML(Document doc) {
        Element eli = doc.createElement("vFloat");
        eli.setAttribute("title", this.getTitle());
        eli.setAttribute("keyframed", String.valueOf(this.getKeyframingEnabled()));
        eli.setAttribute("interPolationType", String.valueOf(this.getInterpolationType()));
        int kfi = 0;
        while (kfi < this.keyframes.length) {
            Element kfe = doc.createElement("key");
            kfe.setAttribute("t", "" + this.keyframes[kfi].time);
            kfe.setAttribute("v", "" + this.keyframes[kfi].value);
            eli.appendChild(kfe);
            ++kfi;
        }
        return eli;
    }
}

