/*
 * Decompiled with CFR 0.152.
 */
package scene;

import gui.gui_timeline;
import gui.gui_timingSettings;
import gui.guilayer;
import gui.mainwindow;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import opengl.common;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import plug.pluginIF;
import resource.resource;
import resource.resourcemanager;
import scene.layer;
import scene.layerIF;
import vsysTypes.vBool;
import vsysTypes.vFloat;
import vsysTypes.vInt;
import vsysTypes.vKFBoolean;
import vsysTypes.vKFFloat;
import vsysTypes.vKFInt;
import vsysTypes.vResource;

public class vproject {
    public static String currentFile = "";

    public static void saveas() {
        FileDialog fd = new FileDialog((Frame)mainwindow.myFrame, "save project...", 1);
        fd.show();
        fd.dispose();
        vproject p = new vproject();
        p.save(String.valueOf(fd.getDirectory()) + fd.getFile());
        currentFile = String.valueOf(fd.getDirectory()) + fd.getFile();
    }

    public void save(String filename) {
        this.save(common.resman, filename);
    }

    public void save(resourcemanager man, String filename) {
        System.out.println("saving project..." + filename);
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("vsys");
            doc.appendChild(root);
            if (common.controlPlug != null) {
                root.appendChild(this.savePlugin(common.controlPlug.getPlugin(), doc, "controlPlug"));
            }
            int i = 0;
            while (i < common.scenes.length) {
                Vector layers = common.scenes[i].getLayers();
                if (layers.size() > 0) {
                    Element xmlSub = doc.createElement("scene");
                    gui_timingSettings s = (gui_timingSettings)common.scenes[i].getTimingSettings();
                    xmlSub.setAttribute("num", "" + i);
                    xmlSub.setAttribute("timingZoom", "" + s.zoom);
                    xmlSub.setAttribute("timingScroll", "" + s.getScrolltime());
                    xmlSub.setAttribute("timingCurrentTime", "" + s.getCurrentTime());
                    int li = 0;
                    while (li < layers.size()) {
                        layerIF layer2 = (layerIF)layers.get(li);
                        Element el = doc.createElement("layer");
                        el.setAttribute("id", "" + layer2.getID());
                        el.setAttribute("setClearDepth", "" + layer2.getSettingsCleardepth());
                        el.setAttribute("setIdentity", "" + layer2.getSettingsIdentity());
                        el.setAttribute("setLighting", "" + layer2.getSettingsLighting());
                        pluginIF plug = layer2.getPlugin();
                        el.appendChild(this.savePlugin(plug, doc, "plugin"));
                        xmlSub.appendChild(el);
                        ++li;
                    }
                    root.appendChild(xmlSub);
                }
                ++i;
            }
            Element xmlMarker = doc.createElement("marker");
            vKFFloat vi = gui_timeline.marker;
            Element eli = doc.createElement("vFloat");
            eli.setAttribute("title", vi.getTitle());
            eli.setAttribute("keyframed", String.valueOf(vi.getKeyframingEnabled()));
            eli.setAttribute("interPolationType", String.valueOf(vi.getInterpolationType()));
            int kfi = 0;
            while (kfi < vi.keyframes.length) {
                Element kfe = doc.createElement("key");
                kfe.setAttribute("t", "" + vi.keyframes[kfi].time);
                kfe.setAttribute("v", "" + vi.keyframes[kfi].value);
                xmlMarker.appendChild(kfe);
                ++kfi;
            }
            root.appendChild(eli);
            root.appendChild(xmlMarker);
            Element xmlResources = doc.createElement("resources");
            Vector resources = man.getAllResources();
            int i2 = 0;
            while (i2 < resources.size()) {
                resource r = (resource)resources.get(i2);
                Element el = doc.createElement("resource");
                el.setAttribute("filename", r.getFilename());
                el.setAttribute("path", r.getPath());
                xmlResources.appendChild(el);
                ++i2;
            }
            root.appendChild(xmlResources);
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            PrintWriter fout = new PrintWriter(new FileWriter(filename));
            fout.print(xmlString);
            fout.close();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        System.out.println("saving project finished...");
    }

    private Element savePlugin(pluginIF plug, Document doc, String title) {
        Element el = doc.createElement(title);
        if (plug == null) {
            return el;
        }
        try {
            Vector resources;
            Vector floats;
            Vector ints;
            el.setAttribute("class", plug.getClass().getSimpleName());
            el.setAttribute("name", plug.getName());
            el.setAttribute("version", "" + plug.getVersion());
            el.setAttribute("author", plug.getAuthor());
            Vector bools = plug.getVsysBools();
            if (bools.size() > 0) {
                int i = 0;
                while (i < bools.size()) {
                    vBool vi = (vBool)bools.get(i);
                    Element eli = doc.createElement("vBoolean");
                    eli.setAttribute("title", vi.getTitle());
                    eli.setAttribute("v", "" + vi.getValue());
                    el.appendChild(eli);
                    ++i;
                }
            }
            Vector v2dposes = plug.getVsysInteger();
            v2dposes.size();
            Vector kfbools = plug.getVsysKFBools();
            if (kfbools.size() > 0) {
                int i = 0;
                while (i < kfbools.size()) {
                    vKFBoolean vi = (vKFBoolean)kfbools.get(i);
                    Element eli = doc.createElement("vKFBool");
                    eli.setAttribute("title", vi.getTitle());
                    eli.setAttribute("keyframed", String.valueOf(vi.getKeyframingEnabled()));
                    int kfi = 0;
                    while (kfi < vi.keyframes.length) {
                        Element kfe = doc.createElement("key");
                        kfe.setAttribute("t", "" + vi.keyframes[kfi].time);
                        kfe.setAttribute("v", "" + vi.keyframes[kfi].getValue());
                        eli.appendChild(kfe);
                        ++kfi;
                    }
                    el.appendChild(eli);
                    ++i;
                }
            }
            if ((ints = plug.getVsysInteger()).size() > 0) {
                int i = 0;
                while (i < ints.size()) {
                    vKFInt vi = (vKFInt)ints.get(i);
                    Element eli = doc.createElement("vInt");
                    eli.setAttribute("title", vi.getTitle());
                    eli.setAttribute("keyframed", String.valueOf(vi.getKeyframingEnabled()));
                    eli.setAttribute("interPolationType", String.valueOf(vi.getInterpolationType()));
                    int kfi = 0;
                    while (kfi < vi.keyframes.length) {
                        Element kfe = doc.createElement("key");
                        kfe.setAttribute("t", "" + vi.keyframes[kfi].time);
                        kfe.setAttribute("v", "" + vi.keyframes[kfi].value);
                        eli.appendChild(kfe);
                        ++kfi;
                    }
                    el.appendChild(eli);
                    ++i;
                }
            }
            if ((floats = plug.getVsysFloats()).size() > 0) {
                int i = 0;
                while (i < floats.size()) {
                    vKFFloat vi = (vKFFloat)floats.get(i);
                    Element eli = doc.createElement("vFloat");
                    eli.setAttribute("title", vi.getTitle());
                    eli.setAttribute("keyframed", String.valueOf(vi.getKeyframingEnabled()));
                    eli.setAttribute("interPolationType", String.valueOf(vi.getInterpolationType()));
                    int kfi = 0;
                    while (kfi < vi.keyframes.length) {
                        Element kfe = doc.createElement("key");
                        kfe.setAttribute("t", "" + vi.keyframes[kfi].time);
                        kfe.setAttribute("v", "" + vi.keyframes[kfi].value);
                        eli.appendChild(kfe);
                        ++kfi;
                    }
                    el.appendChild(eli);
                    ++i;
                }
            }
            if ((resources = plug.getVsysResourceselects()).size() > 0) {
                int i = 0;
                while (i < resources.size()) {
                    vResource vi = (vResource)resources.get(i);
                    Element eli = doc.createElement("vResource");
                    eli.setAttribute("title", vi.getTitle());
                    if (vi.getResource() != null) {
                        eli.setAttribute("resourceFilename", vi.getResource().getFilename());
                        eli.setAttribute("resourcePath", vi.getResource().getPath());
                        eli.setAttribute("resourceType", vi.getResource().getTypeDescr());
                    }
                    el.appendChild(eli);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return el;
    }

    public void load(String filename) {
        if (filename == null) {
            return;
        }
        System.out.println("loading project...");
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(filename);
            doc.getDocumentElement().normalize();
            System.out.println("Root element of the doc is " + doc.getDocumentElement().getNodeName());
            NodeList xmlResources = doc.getElementsByTagName("resource");
            int gs = 0;
            while (gs < xmlResources.getLength()) {
                Node sceneNode = xmlResources.item(gs);
                NamedNodeMap atts = sceneNode.getAttributes();
                String path = "";
                String fn = "";
                int i = 0;
                while (i < atts.getLength()) {
                    String whichproperty = atts.item(i).getNodeName();
                    String value = atts.item(i).getNodeValue();
                    System.out.println(whichproperty);
                    System.out.println(value);
                    if (whichproperty.equals("filename")) {
                        fn = value;
                    }
                    if (whichproperty.equals("path")) {
                        path = value;
                    }
                    ++i;
                }
                common.resman.add(path, fn);
                ++gs;
            }
            NodeList xmlMarker = doc.getElementsByTagName("marker");
            if (xmlMarker.item(0) != null) {
                gui_timeline.marker.keyframes = this.loadVFloatKeys(xmlMarker.item(0));
            }
            NodeList xmlControlPlugs = doc.getElementsByTagName("controlPlug");
            int gs2 = 0;
            while (gs2 < xmlControlPlugs.getLength()) {
                Node sceneNode = xmlControlPlugs.item(gs2);
                common.setControlPlug(this.loadPlugin(sceneNode, true));
                ++gs2;
            }
            NodeList xmlscene = doc.getElementsByTagName("scene");
            int currentScene = 0;
            int gs3 = 0;
            while (gs3 < xmlscene.getLength()) {
                float currentTime = 0.0f;
                float zoom = 0.5f;
                float scroll = -5.0f;
                int length = 60;
                Node sceneNode = xmlscene.item(gs3);
                NamedNodeMap atts = sceneNode.getAttributes();
                int ai = 0;
                while (ai < atts.getLength()) {
                    String whichproperty = atts.item(ai).getNodeName();
                    String value = atts.item(ai).getNodeValue();
                    if (whichproperty.equals("num")) {
                        currentScene = Integer.parseInt(value);
                    }
                    if (whichproperty.equals("timingCurrentTime")) {
                        currentTime = Float.parseFloat(value);
                    }
                    if (whichproperty.equals("timingZoom")) {
                        zoom = Float.parseFloat(value);
                    }
                    if (whichproperty.equals("timingScroll")) {
                        scroll = Float.parseFloat(value);
                    }
                    if (whichproperty.equals("timingLength")) {
                        length = Integer.parseInt(value);
                    }
                    ++ai;
                }
                NodeList childs = sceneNode.getChildNodes();
                int i = 0;
                while (i < childs.getLength()) {
                    Node n = childs.item(i);
                    if (n.getNodeName().equals("layer")) {
                        atts = n.getAttributes();
                        layerIF newlayer = this.loadLayer(n);
                        int ai2 = 0;
                        while (ai2 < atts.getLength()) {
                            String whichproperty = atts.item(ai2).getNodeName();
                            String value = atts.item(ai2).getNodeValue();
                            if (whichproperty.equals("setClearDepth")) {
                                newlayer.setSettingsCleardepth(Boolean.parseBoolean(value));
                            }
                            if (whichproperty.equals("setIdentity")) {
                                newlayer.setSettingsIdentity(Boolean.parseBoolean(value));
                            }
                            if (whichproperty.equals("setLighting")) {
                                newlayer.setSettingsLighting(Boolean.parseBoolean(value));
                            }
                            ++ai2;
                        }
                        common.scenes[currentScene].addLayer(newlayer);
                        common.scenes[currentScene].setTimingCurrentTime(currentTime);
                        common.scenes[currentScene].setTimingZoom(zoom);
                        common.scenes[currentScene].setTimingScroll(scroll);
                        common.scenes[currentScene].setLength(length);
                    }
                    ++i;
                }
                ++gs3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("load finished...");
    }

    public layerIF loadLayer(Node n) {
        System.out.println("layer");
        NodeList nl = n.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node np = nl.item(i);
            if (np.getNodeName().equals("plugin")) {
                return this.loadPlugin(np, false);
            }
            ++i;
        }
        return null;
    }

    public layerIF loadPlugin(Node n, boolean verysmall) {
        layerIF l = null;
        System.out.println("!!!!!!!!!!!!!! plugin");
        NamedNodeMap atts = n.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            String whichproperty = atts.item(i).getNodeName();
            String value = atts.item(i).getNodeValue();
            System.out.println(whichproperty);
            System.out.println(value);
            if (whichproperty.equals("class")) {
                l = common.guimode ? new guilayer(value, value, verysmall) : new layer(value);
            }
            ++i;
        }
        NodeList nl = n.getChildNodes();
        System.out.println("childnodes:" + nl.getLength());
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node np = nl.item(i2);
            if (!np.getNodeName().equals("#text")) {
                System.out.println("loadchild: " + np.getNodeName());
                String title = "";
                String resourceFilename = "";
                String resourcePath = "";
                boolean keyframed = false;
                boolean booleanValue = false;
                int interpolationtype = 0;
                atts = np.getAttributes();
                if (atts != null) {
                    int ai = 0;
                    while (ai < atts.getLength()) {
                        String whichproperty = atts.item(ai).getNodeName();
                        String value = atts.item(ai).getNodeValue();
                        System.out.println(whichproperty);
                        System.out.println(value);
                        if (whichproperty.equals("title")) {
                            title = value;
                        }
                        if (np.getNodeName().equals("vBoolean") && whichproperty.equals("v")) {
                            booleanValue = Boolean.parseBoolean(value);
                        }
                        if (whichproperty.equals("resourceFilename")) {
                            resourceFilename = value;
                        }
                        if (whichproperty.equals("resourcePath")) {
                            resourcePath = value;
                        }
                        if (whichproperty.equals("keyframed")) {
                            keyframed = Boolean.parseBoolean(value);
                        }
                        if (whichproperty.equals("interPolationType")) {
                            interpolationtype = Integer.parseInt(value);
                        }
                        ++ai;
                    }
                }
                if (np.getNodeName().equals("vFloat")) {
                    l.getPlugin().setPlugKeys(title, keyframed, this.loadVFloatKeys(np), interpolationtype);
                }
                if (np.getNodeName().equals("vInt")) {
                    l.getPlugin().setPlugKeys(title, keyframed, this.loadVIntKeys(np), interpolationtype);
                }
                if (np.getNodeName().equals("vKFBool")) {
                    l.getPlugin().setPlugKeys(title, keyframed, this.loadVKFBoolKeys(np), interpolationtype);
                }
                if (np.getNodeName().equals("vBoolean")) {
                    l.getPlugin().setValue(title, booleanValue);
                }
                if (np.getNodeName().equals("vResource")) {
                    l.getPlugin().setResource(title, resourceFilename, resourcePath);
                }
            }
            ++i2;
        }
        return l;
    }

    public vFloat[] loadVFloatKeys(Node plug) {
        NodeList childs = plug.getChildNodes();
        System.out.println("NUM:" + childs.getLength());
        vFloat[] keys = new vFloat[childs.getLength() / 2];
        int count = 0;
        int i = 0;
        while (i < childs.getLength()) {
            Node n = childs.item(i);
            if (!n.getNodeName().equals("#text")) {
                System.out.println("keynodename:" + n.getNodeName());
                NamedNodeMap atts = n.getAttributes();
                float keyTime = 0.0f;
                float keyValue = 0.0f;
                int ai = 0;
                while (ai < atts.getLength()) {
                    String whichproperty = atts.item(ai).getNodeName();
                    String value = atts.item(ai).getNodeValue();
                    System.out.println(String.valueOf(count) + " loadVFloatKeys " + whichproperty + ":" + value);
                    if (whichproperty.equals("t")) {
                        keyTime = Float.parseFloat(value);
                    }
                    if (whichproperty.equals("v")) {
                        keyValue = Float.parseFloat(value);
                    }
                    ++ai;
                }
                keys[count] = new vFloat(keyTime, keyValue);
                ++count;
            }
            ++i;
        }
        return keys;
    }

    public vInt[] loadVIntKeys(Node plug) {
        NodeList childs = plug.getChildNodes();
        System.out.println("NUM:" + childs.getLength());
        vInt[] keys = new vInt[childs.getLength() / 2];
        int count = 0;
        int i = 0;
        while (i < childs.getLength()) {
            Node n = childs.item(i);
            if (!n.getNodeName().equals("#text")) {
                System.out.println("keynodename:" + n.getNodeName());
                NamedNodeMap atts = n.getAttributes();
                float keyTime = 0.0f;
                int keyValue = 0;
                int ai = 0;
                while (ai < atts.getLength()) {
                    String whichproperty = atts.item(ai).getNodeName();
                    String value = atts.item(ai).getNodeValue();
                    System.out.println(String.valueOf(count) + " loadVIntKeys " + whichproperty + ":" + value);
                    if (whichproperty.equals("t")) {
                        keyTime = Float.parseFloat(value);
                    }
                    if (whichproperty.equals("v")) {
                        keyValue = Integer.parseInt(value);
                    }
                    ++ai;
                }
                keys[count] = new vInt(keyTime, keyValue);
                ++count;
            }
            ++i;
        }
        return keys;
    }

    public vBool[] loadVKFBoolKeys(Node plug) {
        NodeList childs = plug.getChildNodes();
        System.out.println("NUM:" + childs.getLength());
        vBool[] keys = new vBool[childs.getLength() / 2];
        int count = 0;
        int i = 0;
        while (i < childs.getLength()) {
            Node n = childs.item(i);
            if (!n.getNodeName().equals("#text")) {
                System.out.println("keynodename:" + n.getNodeName());
                NamedNodeMap atts = n.getAttributes();
                float keyTime = 0.0f;
                boolean keyValue = false;
                int ai = 0;
                while (ai < atts.getLength()) {
                    String whichproperty = atts.item(ai).getNodeName();
                    String value = atts.item(ai).getNodeValue();
                    System.out.println(String.valueOf(count) + " loadKFBoolKeys " + whichproperty + ":" + value);
                    if (whichproperty.equals("t")) {
                        keyTime = Float.parseFloat(value);
                    }
                    if (whichproperty.equals("v")) {
                        keyValue = Boolean.parseBoolean(value);
                    }
                    ++ai;
                }
                keys[count] = new vBool(keyTime, keyValue);
                ++count;
            }
            ++i;
        }
        return keys;
    }
}

