/*
 * Decompiled with CFR 0.152.
 */
package resource;

import gui.mainwindow;
import help.help;
import help.log;
import java.io.File;
import java.util.Vector;
import resource.resource;
import resource.resourceIF;
import resource.resourceType;
import resource.resource_dae;
import resource.resource_mp3_fmod;
import resource.resource_qtmov;
import resource.resource_shaderFragment;
import resource.resource_shaderVertex;

public class resourcemanager {
    Vector resources = new Vector();
    Vector resourceTypes = null;
    public boolean allloaded = true;
    public static String alternativepath = "";

    public Vector getAllResources() {
        return this.resources;
    }

    public String[] getAllResourcesForTree(String type) {
        int acount = 0;
        int i = 0;
        while (i < this.resources.size()) {
            resource r = (resource)this.resources.get(i);
            if (r.getTypeDescr().contains(type)) {
                ++acount;
            }
            ++i;
        }
        String[] ret = new String[acount];
        int count = 0;
        int i2 = 0;
        while (i2 < this.resources.size()) {
            resource r = (resource)this.resources.get(i2);
            if (r.getTypeDescr().contains(type)) {
                ret[count] = r.filename;
                ++count;
            }
            ++i2;
        }
        return ret;
    }

    public String[] getAllResourcesForTree() {
        String[] ret = new String[this.resources.size()];
        int count = 0;
        int i = 0;
        while (i < this.resources.size()) {
            resource r = (resource)this.resources.get(i);
            ret[count] = r.filename;
            ++count;
            ++i;
        }
        return ret;
    }

    public String[][] getAllResourcesList(String s) {
        int count = 0;
        System.out.println("getAllResourcesList: " + s);
        int i = 0;
        while (i < this.resources.size()) {
            resource r = (resource)this.resources.get(i);
            if (r.getTypeDescr().equals(s)) {
                ++count;
            }
            System.out.println("resource: " + r.getTypeDescr());
            ++i;
        }
        String[][] ret = new String[count][3];
        count = 0;
        int i2 = 0;
        while (i2 < this.resources.size()) {
            resource r = (resource)this.resources.get(i2);
            if (r.getTypeDescr().equals(s)) {
                ret[count][0] = r.filename;
                ret[count][1] = r.getTypeDescr();
                ret[count][2] = r.getInfo();
                ++count;
            }
            ++i2;
        }
        return ret;
    }

    public void init() {
        this.resourceTypes = new Vector();
        this.resourceTypes.add(new resourceType("resource.resource_textureFile", new String[]{"jpg", "gif", "png"}));
        this.resourceTypes.add(new resourceType("resource.resource_" + resource_qtmov.myClassName, new String[]{"mov", "mpg", "mpeg"}));
        this.resourceTypes.add(new resourceType("resource.resource_" + resource_mp3_fmod.myClassName, new String[]{"mp3"}));
        this.resourceTypes.add(new resourceType("resource.resource_" + resource_dae.myClassName, new String[]{"dae"}));
        this.resourceTypes.add(new resourceType("resource.resource_" + resource_shaderFragment.myClassName, new String[]{"fs"}));
        this.resourceTypes.add(new resourceType("resource.resource_" + resource_shaderVertex.myClassName, new String[]{"vs"}));
        log.add("resourcemanager init");
    }

    public resourceIF getResourceLoaderInstance(String classname) {
        System.out.println("getResourceInstance");
        resourceIF c = null;
        try {
            Class<?> testclass = Class.forName(classname);
            c = (resourceIF)testclass.newInstance();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return c;
    }

    public void add(resourceIF r) {
        if (!(r.getFilename().startsWith("pbuffer") || r.getFilename().startsWith("_vsys") || resourcemanager.fileExist(String.valueOf(r.getPath()) + r.getFilename()))) {
            if (!resourcemanager.fileExist(String.valueOf(alternativepath) + r.getFilename())) {
                System.out.println("resource file not found:" + r.getPath() + r.getFilename());
                System.exit(1);
            } else {
                r.setPath(alternativepath);
            }
        }
        this.resources.add(r);
        mainwindow.updateTree();
        this.allloaded = false;
    }

    public static boolean fileExist(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            log.add("does not exist:" + filename);
            return false;
        }
        return true;
    }

    public resourceIF add(String path, String filename) {
        File f;
        if (this.allreadyloaded(filename)) {
            return this.getResourceByFileName(filename);
        }
        if (this.getResourceByFileName(filename) != null) {
            return null;
        }
        if (filename.equals("pbuffer")) {
            return null;
        }
        if (filename.equals("_vsys")) {
            return null;
        }
        if (System.getProperty("javaroot") != null && !(f = new File(String.valueOf(path = String.valueOf(System.getProperty("javaroot")) + "demo/") + filename)).exists()) {
            System.out.println("does not exist:" + path + filename);
            System.exit(1);
        }
        if (!resourcemanager.fileExist(String.valueOf(path) + filename)) {
            if (!resourcemanager.fileExist(String.valueOf(alternativepath) + filename)) {
                System.out.println("resource file not found:" + path + filename);
                System.exit(1);
            } else {
                path = alternativepath;
            }
        }
        boolean found = false;
        resourceIF r = null;
        try {
            if (this.resourceTypes == null) {
                this.init();
            }
            int i = 0;
            while (i < this.resourceTypes.size()) {
                resourceType rt = (resourceType)this.resourceTypes.get(i);
                int a = 0;
                while (a < rt.filenameExtensions.length) {
                    if (filename.toLowerCase().endsWith("." + rt.filenameExtensions[a].toLowerCase())) {
                        log.add("adding resource:" + path + "/" + filename);
                        r = this.getResourceLoaderInstance(rt.loaderclass);
                        r.setFilename(filename);
                        r.setPath(path);
                        this.allloaded = false;
                        found = true;
                    }
                    ++a;
                }
                ++i;
            }
            this.resources.add(r);
            mainwindow.updateTree();
            return r;
        }
        catch (Exception e) {
            System.out.println(e);
            mainwindow.updateTree();
            return null;
        }
    }

    boolean allreadyloaded(String fn) {
        int i = 0;
        while (i < this.resources.size()) {
            resourceIF r = (resourceIF)this.resources.get(i);
            if (r.getFilename().equals(fn)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector getResourceNames() {
        Vector v = new Vector();
        int i = 0;
        while (i < this.resources.size()) {
            resourceIF r = (resourceIF)this.resources.get(i);
            Vector<String> info = new Vector<String>();
            info.add(r.getPath());
            info.add(r.getFilename());
            info.add(r.getTypeDescr());
            v.add(info);
            ++i;
        }
        return v;
    }

    public resourceIF getResourceByFileName(String s) {
        if (s == null) {
            return null;
        }
        resourceIF r = null;
        resourceIF rr = null;
        int i = 0;
        while (i < this.resources.size()) {
            r = (resourceIF)this.resources.get(i);
            if (r == null) {
                log.add("OUGH!!!!");
            } else if (r.getFilename().endsWith(s)) {
                rr = r;
            }
            ++i;
        }
        return rr;
    }

    public int numResources(String filter) {
        int count = 0;
        int i = 0;
        while (i < this.resources.size()) {
            resourceIF t = (resourceIF)this.resources.get(i);
            if (t.getTypeDescr().equals(filter)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void printAllResources() {
        int i = 0;
        while (i < this.resources.size()) {
            resourceIF resourceIF2 = (resourceIF)this.resources.get(i);
            ++i;
        }
    }

    public String[] getResourceNamesArray(String filter) {
        log.add("namesarray:");
        int count = 0;
        String[] titles = new String[this.numResources(filter)];
        int i = 0;
        while (i < this.resources.size()) {
            resourceIF t = (resourceIF)this.resources.get(i);
            if (t.getTypeDescr().equals(filter)) {
                titles[count] = t.getFilename();
                ++count;
            }
            System.out.println("namesarray:" + t.getFilename());
            ++i;
        }
        return titles;
    }

    public void copyResourcesTo(String toPath) {
        int i = 0;
        while (i < this.resources.size()) {
            resourceIF t = (resourceIF)this.resources.get(i);
            if (!t.getFilename().startsWith("pbuffer") && !t.getFilename().startsWith("_vsys")) {
                help.copyfile(String.valueOf(t.getPath()) + t.getFilename(), String.valueOf(toPath) + t.getFilename());
            }
            log.add("_" + t.getFilename());
            ++i;
        }
    }
}

