/*
 * Decompiled with CFR 0.152.
 */
package plugins.texture_split;

import java.util.Random;
import opengl.common;
import org.lwjgl.opengl.GL11;
import plug.plugin;
import plug.pluginIF;
import resource.resource_textureFile;
import vsysTypes.vBool;
import vsysTypes.vKFFloat;
import vsysTypes.vKFInt;
import vsysTypes.vResource;

public class texture_split
extends plugin
implements pluginIF {
    public vKFFloat blend;
    public vKFFloat x_faktor;
    public vKFFloat y_faktor;
    public vKFFloat x_noise;
    public vKFFloat y_noise;
    public vKFFloat x_size;
    public vKFFloat y_size;
    public vKFFloat colr;
    public vKFFloat colg;
    public vKFFloat colb;
    public vKFInt cols;
    public vKFInt rows;
    public vKFInt x_mode;
    public vKFInt y_mode;
    public vResource whichtexture;
    public vBool alpha;
    public float[] diffs;
    resource_textureFile text = null;

    @Override
    public String getName() {
        return "texture split";
    }

    @Override
    public float getVersion() {
        return 1.0f;
    }

    @Override
    public void init() {
        this.whichtexture.setResourceType(new resource_textureFile());
        this.cols.setValue(1);
        this.rows.setValue(1);
        this.x_mode.setValue(1);
        this.y_mode.setValue(1);
        this.colr.setValue(1.0f);
        this.colg.setValue(1.0f);
        this.colb.setValue(1.0f);
        this.initDiffs();
    }

    @Override
    public String getAuthor() {
        return "steam";
    }

    @Override
    public void render() {
        common.switchTo2d();
        if (this.whichtexture.getResource() != null && this.whichtexture.wasChanged()) {
            this.text = (resource_textureFile)this.whichtexture.getResource();
        }
        GL11.glColor3f(this.colr.getKeyframedFloatValue(), this.colg.getKeyframedFloatValue(), this.colb.getKeyframedFloatValue());
        if (this.alpha.getValue()) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
        } else {
            GL11.glDisable(3042);
        }
        if (this.text != null) {
            this.text.bind();
        }
        GL11.glEnable(3553);
        GL11.glBegin(7);
        float start_x = 0.0f;
        float start_y = 0.0f;
        float[] texture_x = new float[2];
        float[] texture_y = new float[2];
        int x_row = 0;
        float diff = 0.0f;
        Random r = new Random();
        int col = 0;
        while ((float)col < (float)Math.pow(this.cols.getKeyframedValue(), 2.0)) {
            float size_x = this.getXSize(col, x_row);
            start_x = (float)common.currentContextWidth / (float)Math.pow(this.cols.getKeyframedValue(), 2.0) * (float)col;
            int row = 0;
            while ((float)row < (float)Math.pow(this.rows.getKeyframedValue(), 2.0)) {
                x_row = row;
                texture_x = this.getXTexCoords(col, x_row);
                diff = this.getDiff(col, row);
                float size_y = this.getYSize(col, row);
                start_y = (float)common.currentContextHeight / (float)Math.pow(this.rows.getKeyframedValue(), 2.0) * (float)row;
                texture_y = this.getYTexCoords(col, row);
                GL11.glTexCoord2f(texture_x[0], texture_y[0]);
                GL11.glVertex2f(start_x - this.x_size.getKeyframedFloatValue() * diff, start_y);
                GL11.glTexCoord2f(texture_x[1], texture_y[0]);
                GL11.glVertex2f(start_x + size_x, start_y - this.y_size.getKeyframedFloatValue() * diff);
                GL11.glTexCoord2f(texture_x[1], texture_y[1]);
                GL11.glVertex2f(start_x + size_x + this.x_size.getKeyframedFloatValue() * diff, start_y + size_y);
                GL11.glTexCoord2f(texture_x[0], texture_y[1]);
                GL11.glVertex2f(start_x, start_y + size_y + this.y_size.getKeyframedFloatValue() * diff);
                ++row;
            }
            ++col;
        }
        GL11.glEnd();
        common.switchTo3d();
        GL11.glEnable(2929);
    }

    public float[] getYTexCoords(int col, int row) {
        float[] coords;
        coords = new float[]{1.0f / (float)Math.pow(this.rows.getKeyframedValue(), 2.0) * (float)row, coords[0] + 1.0f / (float)Math.pow(this.rows.getKeyframedValue(), 2.0)};
        switch (this.y_mode.getKeyframedValue()) {
            case 2: {
                if (col % 2 == 0) break;
                coords[1] = 1.0f / (float)Math.pow(this.rows.getKeyframedValue(), 2.0) * (float)row;
                coords[0] = coords[1] + 1.0f / (float)Math.pow(this.rows.getKeyframedValue(), 2.0);
                break;
            }
            case 3: {
                if (col % 2 != 0) {
                    coords[0] = coords[0] + this.y_faktor.getKeyframedFloatValue();
                    coords[1] = coords[1] + this.y_faktor.getKeyframedFloatValue();
                    break;
                }
                coords[0] = coords[0] - this.y_faktor.getKeyframedFloatValue();
                coords[1] = coords[1] - this.y_faktor.getKeyframedFloatValue();
                break;
            }
            case 4: {
                if (row == 0) {
                    row = 1;
                }
                if ((float)(col / row) % this.y_faktor.getKeyframedFloatValue() != 0.0f) {
                    coords[0] = coords[0] * (float)Math.sin(this.y_faktor.getKeyframedFloatValue());
                    coords[1] = coords[1] * (float)Math.sin(this.y_faktor.getKeyframedFloatValue());
                    break;
                }
                coords[0] = coords[0] / (float)Math.sin(this.y_faktor.getKeyframedFloatValue());
                coords[1] = coords[1] / (float)Math.sin(this.y_faktor.getKeyframedFloatValue());
            }
        }
        Random r = new Random();
        coords[0] = coords[0] + r.nextFloat() * 0.1f * this.y_noise.getKeyframedFloatValue();
        coords[1] = coords[1] + r.nextFloat() * 0.1f * this.y_noise.getKeyframedFloatValue();
        return coords;
    }

    public float[] getXTexCoords(int col, int row) {
        float[] coords;
        coords = new float[]{1.0f / (float)Math.pow(this.cols.getKeyframedValue(), 2.0) * (float)col, coords[0] + 1.0f / (float)Math.pow(this.cols.getKeyframedValue(), 2.0)};
        switch (this.x_mode.getKeyframedValue()) {
            case 2: {
                if (row % 2 == 0) break;
                coords[1] = 1.0f / (float)Math.pow(this.cols.getKeyframedValue(), 2.0) * (float)col;
                coords[0] = coords[1] + 1.0f / (float)Math.pow(this.cols.getKeyframedValue(), 2.0);
                break;
            }
            case 3: {
                if (row % 2 != 0) {
                    coords[0] = coords[0] + this.x_faktor.getKeyframedFloatValue();
                    coords[1] = coords[1] + this.x_faktor.getKeyframedFloatValue();
                    break;
                }
                coords[0] = coords[0] - this.x_faktor.getKeyframedFloatValue();
                coords[1] = coords[1] - this.x_faktor.getKeyframedFloatValue();
                break;
            }
            case 4: {
                if (col == 0) {
                    col = 1;
                }
                if ((float)(row / col) % this.x_faktor.getKeyframedFloatValue() != 0.0f) {
                    coords[0] = coords[0] * (float)Math.sin(this.x_faktor.getKeyframedFloatValue());
                    coords[1] = coords[1] * (float)Math.sin(this.x_faktor.getKeyframedFloatValue());
                    break;
                }
                coords[0] = coords[0] / (float)Math.sin(this.x_faktor.getKeyframedFloatValue());
                coords[1] = coords[1] / (float)Math.sin(this.x_faktor.getKeyframedFloatValue());
            }
        }
        Random r = new Random();
        coords[0] = coords[0] + r.nextFloat() * 0.1f * this.x_noise.getKeyframedFloatValue();
        coords[1] = coords[1] + r.nextFloat() * 0.1f * this.x_noise.getKeyframedFloatValue();
        return coords;
    }

    public float getXSize(int col, int row) {
        float size_x = this.cols.getKeyframedValue() != 0 ? (float)common.currentContextWidth / (float)Math.pow(this.cols.getKeyframedValue(), 2.0) : (float)common.currentContextWidth;
        switch (this.x_mode.getKeyframedValue()) {
            case 5: {
                size_x -= size_x * this.x_faktor.getKeyframedFloatValue();
            }
        }
        Random r = new Random();
        return size_x += r.nextFloat() * this.x_size.getKeyframedFloatValue();
    }

    public float getYSize(int col, int row) {
        float size_y = this.rows.getKeyframedValue() != 0 ? (float)common.currentContextHeight / (float)Math.pow(this.rows.getKeyframedValue(), 2.0) : (float)common.currentContextHeight;
        switch (this.y_mode.getKeyframedValue()) {
            case 5: {
                size_y -= size_y * this.y_faktor.getKeyframedFloatValue();
            }
        }
        Random r = new Random();
        return size_y += r.nextFloat() * this.y_size.getKeyframedFloatValue();
    }

    public float getDiff(int col, int row) {
        if (this.cols.getChanged() || this.rows.getChanged()) {
            this.initDiffs();
        }
        int index = col + row;
        return this.diffs[index];
    }

    public float[] initDiffs() {
        int num = (int)Math.pow(this.cols.getKeyframedValue(), 2.0) + (int)Math.pow(this.rows.getKeyframedValue(), 2.0) + 1;
        this.diffs = new float[num];
        Random r = new Random();
        int i = 0;
        while (i < num) {
            this.diffs[i] = r.nextFloat() * 50.0f;
            ++i;
        }
        return this.diffs;
    }
}

