/*
 * Decompiled with CFR 0.152.
 */
package plugins.shader;

import g3d.g3d_shader;
import g3d.g3d_shaderprogram;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.Util;
import plug.plugin;
import plug.pluginIF;
import resource.resource_shaderFragment;
import resource.resource_shaderVertex;
import resource.resource_textureFile;
import vsysTypes.v2DPoint;
import vsysTypes.vKFFloat;
import vsysTypes.vKFInt;
import vsysTypes.vResource;

public class shader
extends plugin
implements pluginIF {
    public vKFInt x;
    public vKFInt y;
    public v2DPoint mypos;
    public vKFFloat multi;
    public vResource fragmentShader;
    public vResource vertexShader;
    g3d_shader vs;
    public vResource whichtexture;
    int programObject = -1;
    g3d_shaderprogram shader = null;
    resource_textureFile text = null;

    @Override
    public String getName() {
        return "shadertest";
    }

    @Override
    public String getAuthor() {
        return "pandur";
    }

    @Override
    public float getVersion() {
        return 0.0f;
    }

    @Override
    public void init() {
        this.mypos.setKFInts(this.x, this.y);
        this.whichtexture.setResourceType(new resource_textureFile());
        this.vertexShader.setResourceType(new resource_shaderVertex());
        this.fragmentShader.setResourceType(new resource_shaderFragment());
    }

    @Override
    public void render() {
        GL11.glClear(256);
        if (this.shader == null) {
            this.shader = new g3d_shaderprogram();
        }
        if (this.whichtexture.getResource() != null && this.whichtexture.wasChanged()) {
            this.text = (resource_textureFile)this.whichtexture.getResource();
        }
        if (this.fragmentShader.getResource() != null && this.fragmentShader.wasChanged()) {
            resource_shaderFragment rfs = (resource_shaderFragment)this.fragmentShader.getResource();
            this.shader.changeShader(rfs.shader);
        }
        if (this.vertexShader.getResource() != null && this.vertexShader.wasChanged()) {
            resource_shaderVertex rvs = (resource_shaderVertex)this.vertexShader.getResource();
            this.shader.changeShader(rvs.shader);
        }
        if (this.text == null) {
            return;
        }
        GL11.glLoadIdentity();
        GL11.glDisable(2884);
        GL11.glDisable(2903);
        GL11.glDisable(2896);
        GL11.glDisable(16384);
        GL11.glDisable(16385);
        GL11.glDisable(3042);
        GL11.glDisable(2929);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3553);
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, this.text.getID());
        this.shader.bind();
        ARBShaderObjects.glUniform1iARB(this.shader.setUniformLocation("mytexture"), 0);
        ARBShaderObjects.glUniform1fARB(this.shader.setUniformLocation("multi"), this.multi.getKeyframedFloatValue() * 20.0f);
        this.renderQuad();
        this.shader.unbind();
    }

    private static ByteBuffer getProgramCode(String filename) {
        ClassLoader fileLoader = shader.class.getClassLoader();
        InputStream fileInputStream = fileLoader.getResourceAsStream(filename);
        byte[] shaderCode = null;
        try {
            if (fileInputStream == null) {
                fileInputStream = new FileInputStream(filename);
            }
            DataInputStream dataStream = new DataInputStream(fileInputStream);
            shaderCode = new byte[fileInputStream.available()];
            dataStream.readFully(shaderCode);
            fileInputStream.close();
            dataStream.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        ByteBuffer shaderPro = BufferUtils.createByteBuffer(shaderCode.length);
        shaderPro.put(shaderCode);
        shaderPro.flip();
        return shaderPro;
    }

    private void printLogInfo(int obj) {
        IntBuffer iVal = BufferUtils.createIntBuffer(1);
        ARBShaderObjects.glGetObjectParameterARB(obj, 35716, iVal);
        int length = iVal.get();
        System.out.println("Info log length:" + length);
        if (length > 0) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer(length);
            iVal.flip();
            ARBShaderObjects.glGetInfoLogARB(obj, iVal, infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            String out = new String(infoBytes);
            System.out.println("Info log:\n" + out);
        }
        Util.checkGLError();
    }

    public void renderQuad() {
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        GL11.glTranslatef(0.0f, 0.0f, -1.0f);
        float x = 0.0f;
        float y = 0.0f;
        float width = 0.5f;
        float height = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.0f;
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, f1);
        GL13.glMultiTexCoord2f(0, 0.0f, f1);
        GL11.glVertex3f(x - width / 2.0f, -1.0f * y + height / 2.0f, 0.0f);
        GL13.glMultiTexCoord2f(0, 0.0f, f2);
        GL11.glVertex3f(x - width / 2.0f, -1.0f * y - height / 2.0f, 0.0f);
        GL13.glMultiTexCoord2f(0, 1.0f, f2);
        GL11.glVertex3f(x + width / 2.0f, -1.0f * y - height / 2.0f, 0.0f);
        GL13.glMultiTexCoord2f(0, 1.0f, f1);
        GL11.glVertex3f(x + width / 2.0f, -1.0f * y + height / 2.0f, 0.0f);
        GL11.glEnd();
    }
}

