/*
 * Decompiled with CFR 0.152.
 */
package plugins.framebufferStart;

import java.nio.IntBuffer;
import opengl.common;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import plug.plugin;
import plug.pluginIF;
import resource.resource_textureFile;
import vsysTypes.vResource;

public class framebufferStart
extends plugin
implements pluginIF {
    public vResource whichBuffer;
    resource_textureFile texture;
    int frameBuffer = -1;
    boolean inited = false;

    @Override
    public String getName() {
        return "framebuffer";
    }

    @Override
    public String getAuthor() {
        return "pandur";
    }

    @Override
    public float getVersion() {
        return 1.0f;
    }

    @Override
    public void init() {
        this.whichBuffer.setResourceType(new resource_textureFile());
    }

    @Override
    public void render() {
        if (this.whichBuffer.getResource() != null || this.whichBuffer.wasChanged()) {
            this.texture = (resource_textureFile)this.whichBuffer.getResource();
        }
        if (this.texture == null) {
            return;
        }
        if (!this.inited) {
            try {
                IntBuffer ib_fb = BufferUtils.createIntBuffer(1);
                EXTFramebufferObject.glGenFramebuffersEXT(ib_fb);
                this.frameBuffer = ib_fb.get(0);
                this.bind();
                this.checkFrameBufferStatus();
                framebufferStart.unbind();
                this.inited = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        this.bind();
    }

    void checkFrameBufferStatus() {
        int er = EXTFramebufferObject.glCheckFramebufferStatusEXT(36160);
        switch (er) {
            case 36053: {
                System.out.println("framebuffer complete...");
                break;
            }
            case 36054: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT exception");
            }
            case 36055: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT exception");
            }
            case 36057: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT exception");
            }
            case 36059: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT exception");
            }
            case 36058: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT exception");
            }
            case 36060: {
                throw new RuntimeException("FrameBuffer: " + this.frameBuffer + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT exception");
            }
            default: {
                throw new RuntimeException("Unexpected reply from glCheckFramebufferStatusEXT: " + er);
            }
        }
    }

    public void bind() {
        EXTFramebufferObject.glBindFramebufferEXT(36160, this.frameBuffer);
        EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36064, 34037, this.texture.getID(), 0);
        GL11.glPushAttrib(2048);
        GL11.glViewport(0, 0, this.texture.width, this.texture.height);
        GL11.glClear(16384);
        common.glInit(this.texture.width, this.texture.height);
        IntBuffer ib = BufferUtils.createIntBuffer(1);
        ib.put(0, 36064);
        GL20.glDrawBuffers(ib);
    }

    public static void unbind() {
        EXTFramebufferObject.glBindFramebufferEXT(36160, 0);
        GL11.glPopAttrib();
    }
}

