/*
 * Decompiled with CFR 0.152.
 */
package plugins.displaytexture;

import opengl.common;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import plug.plugin;
import plug.pluginIF;
import resource.resource_textureFile;
import vsysTypes.v2DPoint;
import vsysTypes.vBool;
import vsysTypes.vKFFloat;
import vsysTypes.vKFInt;
import vsysTypes.vResource;

public class displaytexture
extends plugin
implements pluginIF {
    public vKFFloat blend;
    public vKFFloat size;
    public vKFInt x;
    public vKFInt y;
    public vResource whichtexture;
    public v2DPoint mypos;
    public vBool fullscreen;
    public vBool flip;
    public vBool alpha;
    public vKFInt swidth;
    resource_textureFile text = null;

    @Override
    public String getName() {
        return "display texture";
    }

    @Override
    public float getVersion() {
        return 1.0f;
    }

    @Override
    public void init() {
        this.whichtexture.setResourceType(new resource_textureFile());
        this.size.setValue(0.5f);
        this.mypos.setKFInts(this.x, this.y);
        this.swidth.setValue(1);
    }

    @Override
    public String getAuthor() {
        return "pandur";
    }

    public void renderFullscreen() {
        common.switchTo2d();
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        int y1 = common.currentContextHeight;
        int y2 = 0;
        if (this.flip.getValue()) {
            y1 = 0;
            y2 = common.currentContextHeight;
        }
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f - this.blend.getKeyframedFloatValue());
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(0.0f, y1);
        GL11.glTexCoord2f(0.0f, 1.0f * (float)this.text.height);
        GL11.glVertex2f(0.0f, y2);
        GL11.glTexCoord2f(1.0f * (float)this.text.width, 1.0f * (float)this.text.height);
        GL11.glVertex2f(common.currentContextWidth, y2);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glTexCoord2f(1.0f * (float)this.text.width, 0.0f);
        GL11.glVertex2f(common.currentContextWidth, y1);
        GL11.glEnd();
        common.switchTo3d();
    }

    public void renderNormal() {
        common.switchTo2d(common.currentContextWidth, common.currentContextHeight);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        int x = (int)((float)this.mypos.x.getKeyframedValue() / 512.0f * (float)common.currentContextWidth);
        int y = (int)((float)this.mypos.y.getKeyframedValue() / 384.0f * (float)common.currentContextHeight);
        int width = (int)((float)common.currentContextWidth * (1.0f - this.size.getKeyframedFloatValue()) * 1.0f);
        int height = (int)((float)common.currentContextWidth * (1.0f - this.size.getKeyframedFloatValue()));
        float f1 = 0.0f;
        float f2 = 1 * this.text.height;
        if (this.flip.getValue()) {
            f1 = 1 * this.text.height;
            f2 = 0.0f;
        }
        GL11.glBegin(7);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f - this.blend.getKeyframedFloatValue());
        GL11.glTexCoord2f(0.0f, f1);
        GL11.glVertex2f(x - width / 2, -1 * y + height / 2);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f - this.blend.getKeyframedFloatValue());
        GL11.glTexCoord2f(0.0f, f2);
        GL11.glVertex2f(x - width / 2, -1 * y - height / 2);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f - this.blend.getKeyframedFloatValue());
        GL11.glTexCoord2f(1.0f * (float)this.text.width, f2);
        GL11.glVertex2f(x + width / 2, -1 * y - height / 2);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f - this.blend.getKeyframedFloatValue());
        GL11.glTexCoord2f(1.0f * (float)this.text.width, f1);
        GL11.glVertex2f(x + width / 2, -1 * y + height / 2);
        GL11.glEnd();
        common.switchTo3d();
    }

    @Override
    public void render() {
        if (this.whichtexture.getResource() != null && this.whichtexture.wasChanged()) {
            this.text = (resource_textureFile)this.whichtexture.getResource();
        }
        if (this.text == null) {
            return;
        }
        GL11.glLoadIdentity();
        GL11.glDisable(2884);
        GL11.glDisable(2903);
        GL11.glDisable(2896);
        GL11.glDisable(3042);
        GL11.glDisable(3553);
        GL13.glActiveTexture(33984);
        GL11.glEnable(34037);
        GL11.glDisable(2929);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        if (this.alpha.getValue()) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            if (this.blend.getKeyframedFloatValue() == 1.0f) {
                return;
            }
        } else {
            GL11.glDisable(3042);
        }
        if (this.text != null) {
            this.text.bind();
        }
        if (this.fullscreen.getValue()) {
            this.renderFullscreen();
        } else {
            this.renderNormal();
        }
        GL11.glEnable(2929);
    }
}

