/*
 * Decompiled with CFR 0.152.
 */
package plugins.boid_lines;

import common.timer;
import org.lwjgl.opengl.GL11;
import plug.plugin;
import plug.pluginIF;
import plugins.boid_lines.boid;
import plugins.boid_lines.flock;
import vsysTypes.vBool;
import vsysTypes.vKFFloat;
import vsysTypes.vKFInt;

public class boid_lines
extends plugin
implements pluginIF {
    public vKFFloat translationX;
    public vKFFloat translationY;
    public vKFFloat translationZ;
    public vKFInt number_of_boids;
    public vBool destroy;
    public vBool turn;
    public vKFFloat velocity;
    public vKFFloat radius;
    public vKFFloat size;
    public vBool redraw;
    public vKFFloat blend;
    public vBool alpha;
    public flock flock;
    timer mytime = new timer();

    @Override
    public String getAuthor() {
        return "steam";
    }

    @Override
    public String getName() {
        return "boid lines";
    }

    @Override
    public float getVersion() {
        return 1.0f;
    }

    @Override
    public void init() {
        this.number_of_boids.setValue(60);
        this.velocity.setValue(1.0f);
        this.radius.setValue(0.15f);
        this.destroy.setValue(false);
        this.size.setValue(0.2f);
        this.translationX.setValue(0.45f);
        this.translationY.setValue(0.45f);
        this.translationZ.setValue(0.5f);
        this.alpha.setValue(true);
        this.newFlock();
    }

    public void newFlock() {
        this.flock = new flock(this.number_of_boids.getKeyframedValue());
    }

    public void update() {
        if (this.redraw.getValue()) {
            this.newFlock();
            this.redraw.setValue(false);
        }
        if (this.number_of_boids.getChanged()) {
            if (this.flock.boids.size() > this.number_of_boids.getKeyframedValue()) {
                this.flock.removeBoids(this.flock.boids.size() - this.number_of_boids.getKeyframedValue());
            } else if (this.flock.boids.size() < this.number_of_boids.getKeyframedValue()) {
                this.flock.addBoids(this.number_of_boids.getKeyframedValue() - this.flock.boids.size());
            }
        }
        this.flock.setVelocity(this.velocity);
        this.flock.setRadius(this.radius);
        this.flock.update(this.destroy, this.turn);
    }

    @Override
    public void render() {
        this.update();
        this.drawLines();
    }

    public void initGL() {
        GL11.glLoadIdentity();
        GL11.glTranslatef((this.translationX.getKeyframedFloatValue() - 0.5f) * 6.0f, (this.translationY.getKeyframedFloatValue() - 0.5f) * 6.0f, (this.translationZ.getKeyframedFloatValue() - 0.5f) * 120.0f - 5.0f);
        GL11.glRotatef(this.mytime.getTime() * 30.0f, 0.7f, 1.0f, 0.8f);
        if (this.alpha.getValue()) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
        } else {
            GL11.glDisable(3042);
        }
    }

    public void drawLines() {
        this.initGL();
        GL11.glDisable(5890);
        GL11.glLineWidth(this.size.getKeyframedFloatValue() * 4.0f);
        GL11.glEnable(2848);
        float current_alpha = 0.0f;
        int i = 0;
        while (i < this.flock.boids.size()) {
            boid b = this.flock.boids.get(i);
            b.pushPosition();
            if (b.positions.size() >= 50) {
                int k = 2;
                while (k > 0) {
                    GL11.glLineWidth(this.size.getKeyframedFloatValue() * 4.0f * (float)k);
                    GL11.glBegin(1);
                    int j = 0;
                    while (j < 48) {
                        current_alpha = (float)j / 48.0f;
                        int index = b.positions_counter + j;
                        float[] position = b.getEarlierPosition(index);
                        float[] next_position = b.getEarlierPosition(index + 1);
                        GL11.glColor4f(0.0f, 0.0f, 0.0f, current_alpha / (float)k);
                        GL11.glVertex4f(position[0], position[1], position[2], current_alpha);
                        GL11.glVertex4f(next_position[0], next_position[1], next_position[2], current_alpha);
                        ++j;
                    }
                    GL11.glEnd();
                    --k;
                }
                GL11.glEnd();
            }
            ++i;
        }
    }
}

