/*
 * Decompiled with CFR 0.152.
 */
package plugins.boid_lines;

import java.util.ArrayList;
import java.util.Random;
import plugins.boid_lines.flock;

public class boid {
    int id;
    Random r = new Random();
    float[][] box = new float[3][2];
    float[] pos = new float[3];
    float[] velo = new float[3];
    ArrayList<float[]> positions = new ArrayList();
    int positions_counter = 0;

    boid(int id) {
        this.id = id;
        this.box[0][0] = -4.0f;
        this.box[0][1] = 4.0f;
        this.box[1][0] = -4.0f;
        this.box[1][1] = 4.0f;
        this.box[2][0] = -4.0f;
        this.box[2][1] = 4.0f;
        this.pos[0] = this.r.nextFloat();
        this.pos[1] = this.r.nextFloat();
        this.pos[2] = this.r.nextFloat();
        this.velo[0] = this.r.nextFloat();
        this.velo[1] = this.r.nextFloat();
        this.velo[2] = this.r.nextFloat();
    }

    public float[] moveTowards(flock flock2) {
        float[] pc = new float[3];
        int i = 0;
        while (i < flock2.boids.size()) {
            boid b = flock2.boids.get(i);
            if (b.id != this.id) {
                pc = this.vectorAdd(pc, b.getPosition());
            }
            ++i;
        }
        pc = this.vectorDiv(pc, flock2.boids.size() - 1);
        Random r = new Random();
        int speed = r.nextInt(10);
        return this.vectorRound(this.vectorDiv(this.vectorSubst(pc, this.getPosition()), speed));
    }

    public float[] moveAway(flock flock2) {
        float[] c = new float[3];
        int i = 0;
        while (i < flock2.boids.size()) {
            boid b = flock2.boids.get(i);
            if (b.id != this.id && this.vectorDiffLess(this.getPosition(), b.getPosition(), flock2.radius)) {
                c = this.vectorAdd(c, this.vectorSubst(this.getPosition(), b.getPosition()));
            }
            ++i;
        }
        return this.vectorRound(c);
    }

    public float[] moveToTarget(float[] place) {
        int speed = 100;
        return this.vectorDiv(this.vectorSubst(place, this.getPosition()), speed);
    }

    public float[] matchSpeed(flock flock2) {
        float[] pv = new float[3];
        int i = 0;
        while (i < flock2.boids.size()) {
            boid b = flock2.boids.get(i);
            if (b.id != this.id) {
                pv = this.vectorAdd(pv, b.getVelocity());
            }
            ++i;
        }
        pv = this.vectorDiv(pv, flock2.boids.size() - 1);
        return this.vectorDiv(this.vectorSubst(pv, this.getVelocity()), 8);
    }

    public float getX() {
        return this.pos[0];
    }

    public float getY() {
        return this.pos[1];
    }

    public float getZ() {
        return this.pos[2];
    }

    public float[] getPosition() {
        return this.pos;
    }

    public float getVeloX() {
        return this.velo[0];
    }

    public float getVeloY() {
        return this.velo[1];
    }

    public float getVeloZ() {
        return this.velo[2];
    }

    public float[] getVelocity() {
        return this.vectorSin(this.velo);
    }

    public void setPosition(float[] pos) {
        this.pos = pos;
    }

    public void setVelocity(float[] velo, float limit) {
        if (this.vectorMore(velo, limit)) {
            velo = this.vectorMultiply(this.vectorDiv(velo, this.vectorAbs(velo)), limit);
        }
        this.velo = this.vectorSin(velo);
    }

    public float[] vectorAdd(float[] v1, float[] v2) {
        float[] v = new float[]{v1[0] + v2[0], v1[1] + v2[1], v1[2] + v2[2]};
        return v;
    }

    public float[] vectorSubst(float[] v1, float[] v2) {
        float[] v = new float[]{v1[0] - v2[0], v1[1] - v2[1], v1[2] - v2[2]};
        return v;
    }

    public float[] vectorDiv(float[] v1, float[] v2) {
        float[] v = new float[]{v1[0] / v2[0], v1[1] / v2[1], v1[2] / v2[2]};
        return v;
    }

    public float[] vectorDiv(float[] v1, int div) {
        float[] v = new float[]{v1[0] / (float)div, v1[1] / (float)div, v1[2] / (float)div};
        return v;
    }

    public float[] vectorMultiply(float[] v1, float f) {
        float[] v = new float[]{v1[0] * f, v1[1] * f, v1[2] * f};
        return v;
    }

    public float[] vectorAbs(float[] v1) {
        float[] v = new float[]{Math.abs(v1[0]), Math.abs(v1[1]), Math.abs(v1[2])};
        return v;
    }

    public boolean vectorDiffLess(float[] v1, float[] v2, float diff) {
        return Math.abs(v1[0] - v2[0]) < diff && Math.abs(v1[1] - v2[1]) < diff && Math.abs(v1[2] - v2[2]) < diff;
    }

    public boolean vectorMore(float[] v1, float f) {
        if (Math.abs(v1[0]) > f) {
            return true;
        }
        if (Math.abs(v1[1]) > f) {
            return true;
        }
        return Math.abs(v1[2]) > f;
    }

    public float[] vectorRound(float[] v) {
        float[] v1 = new float[]{(float)Math.round(v[0]) / 100.0f, (float)Math.round(v[1]) / 100.0f, (float)Math.round(v[2]) / 100.0f};
        return v1;
    }

    public float[] vectorSin(float[] v) {
        float[] v1 = new float[]{(float)Math.sin(v[0]), (float)Math.sin(v[1]), (float)Math.sin(v[2])};
        return v1;
    }

    public void pushPosition() {
        if (this.positions.size() < 50) {
            this.positions.add(this.getPosition());
        } else {
            this.positions.remove(this.positions_counter);
            this.positions.add(this.positions_counter, this.getPosition());
            this.positions_counter = this.positions_counter < 49 ? ++this.positions_counter : 0;
        }
    }

    public ArrayList<float[]> getLastPositions() {
        return this.positions;
    }

    public float[] getEarlierPosition(int i) {
        int index = i;
        if (index > this.positions.size() - 1) {
            index = i - this.positions.size();
        }
        return this.positions.get(index);
    }
}

