/*
 * Decompiled with CFR 0.152.
 */
package g3d;

import g3d.g3d_body;
import g3d.g3d_vertex;
import g3d.pointcache_points;
import help.log;
import java.io.DataInputStream;
import java.io.FileInputStream;

public class pointcache {
    int numPoints = 0;
    int numSamples = 0;
    float startFrame = 0.0f;
    float sampleRate = 0.0f;
    float fps = 30.0f;
    pointcache_points[] samples;
    g3d_vertex[] ipVerts;
    float oldcheck = 0.0f;
    float oldtime = 999999.0f;

    public boolean needsRebuild(float time) {
        if (this.oldtime > time) {
            return true;
        }
        if (this.oldcheck == 0.0f) {
            return true;
        }
        float step = time * this.fps / this.sampleRate;
        int cStep = (int)step;
        float diff = step - (float)cStep;
        int nextstep = cStep + 1;
        if ((float)nextstep < this.startFrame || (float)cStep < this.startFrame) {
            return false;
        }
        if ((float)cStep > this.startFrame + (float)this.numSamples - 1.0f) {
            return false;
        }
        if ((float)nextstep > this.startFrame + (float)this.numSamples - 1.0f) {
            return false;
        }
        if ((float)nextstep < (float)this.numSamples + this.startFrame && (float)cStep < (float)this.numSamples + this.startFrame) {
            if (this.samples[nextstep - (int)this.startFrame].check != this.samples[cStep - (int)this.startFrame].check) {
                System.out.println("rebuild!!!");
                return true;
            }
            return false;
        }
        return this.oldcheck != this.samples[cStep].check;
    }

    public g3d_vertex[] getVertices(float time) {
        this.oldtime = time;
        float step = time * this.fps / this.sampleRate;
        int cStep = (int)step;
        float diff = step - (float)cStep;
        int nextstep = cStep + 1;
        if ((float)nextstep < (float)this.numSamples + this.startFrame && (float)cStep < (float)this.numSamples + this.startFrame && diff > 0.0f) {
            int i = 0;
            while (i < this.numPoints) {
                this.ipVerts[i].posx = this.samples[cStep - (int)this.startFrame].vertices[i].posx + (this.samples[nextstep - (int)this.startFrame].vertices[i].posx - this.samples[cStep - (int)this.startFrame].vertices[i].posx) * diff;
                this.ipVerts[i].posy = this.samples[cStep - (int)this.startFrame].vertices[i].posy + (this.samples[nextstep - (int)this.startFrame].vertices[i].posy - this.samples[cStep - (int)this.startFrame].vertices[i].posy) * diff;
                this.ipVerts[i].posz = this.samples[cStep - (int)this.startFrame].vertices[i].posz + (this.samples[nextstep - (int)this.startFrame].vertices[i].posz - this.samples[cStep - (int)this.startFrame].vertices[i].posz) * diff;
                ++i;
            }
            return this.ipVerts;
        }
        if (cStep >= this.numSamples - 1) {
            cStep = this.numSamples - 1;
        }
        this.oldcheck = this.samples[cStep].check;
        return this.samples[cStep].vertices;
    }

    void load(g3d_body b, String filename) {
        try {
            log.log(100, "loading pointcachefile:" + filename);
            FileInputStream fstream = new FileInputStream(filename);
            DataInputStream in = new DataInputStream(fstream);
            String s = "";
            int l = 11;
            byte[] bs = new byte[l];
            in.read(bs, 0, l);
            s = new String(bs);
            System.out.println(s);
            in.readByte();
            log.log(100, "fileVersion:" + pointcache.readIntLittleEndian(in));
            this.numPoints = pointcache.readIntLittleEndian(in);
            this.startFrame = pointcache.readFloatLittleEndian(in);
            this.sampleRate = pointcache.readFloatLittleEndian(in);
            this.numSamples = pointcache.readIntLittleEndian(in);
            System.out.println("pc2 numPoints:" + this.numPoints);
            System.out.println("pc2 startFrame:" + this.startFrame);
            System.out.println("pc2 sampleRate:" + this.sampleRate);
            System.out.println("pc2 numSamples:" + this.numSamples);
            this.samples = new pointcache_points[this.numSamples];
            int j = 0;
            while (j < this.numSamples) {
                this.samples[j] = new pointcache_points();
                this.samples[j].vertices = new g3d_vertex[this.numPoints];
                int i = 0;
                while (i < this.numPoints) {
                    this.samples[j].vertices[i] = new g3d_vertex(pointcache.readFloatLittleEndian(in), pointcache.readFloatLittleEndian(in), pointcache.readFloatLittleEndian(in));
                    ++i;
                }
                this.samples[j].genCheck();
                ++j;
            }
            this.ipVerts = new g3d_vertex[this.numPoints];
            int i = 0;
            while (i < this.numPoints) {
                this.ipVerts[i] = new g3d_vertex();
                ++i;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    static int readIntLittleEndian(DataInputStream data_in) {
        int accum = 0;
        try {
            int shiftBy = 0;
            while (shiftBy < 32) {
                accum |= (data_in.readByte() & 0xFF) << shiftBy;
                shiftBy += 8;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }
        return accum;
    }

    static float readFloatLittleEndian(DataInputStream data_in) {
        int accum = 0;
        try {
            int shiftBy = 0;
            while (shiftBy < 32) {
                accum |= (data_in.readByte() & 0xFF) << shiftBy;
                shiftBy += 8;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }
        return Float.intBitsToFloat(accum);
    }
}

