/*
 * Decompiled with CFR 0.152.
 */
package g3d;

import g3d.g3d_body;
import g3d.g3d_light;
import g3d.g3d_material;
import g3d.g3d_matrix;
import g3d.g3d_matrixAnim;
import g3d.g3d_miniparticles;
import g3d.g3d_vertex;
import g3d.g3d_world;
import g3d.pointcache;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import opengl.common;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import vsysTypes.vKFFloat;

public class g3d_node
implements Serializable {
    public String title = "no title";
    public boolean invert = false;
    public int whichBody = -1;
    public boolean drawMarked = false;
    public boolean sorted = false;
    public boolean picking = false;
    public int pickingname = 0;
    public boolean replacetest = false;
    public boolean billboard = false;
    public boolean nolight = false;
    public boolean drawparticles = false;
    public int replacescene = -1;
    public boolean depthtest = true;
    public g3d_miniparticles myparticles = null;
    public Vector childNodes = new Vector();
    public g3d_vertex randomVertex = new g3d_vertex();
    public static float randomfloatMultiplier = 0.0f;
    public String pointcachefile = null;
    public int order = 100;
    public g3d_matrix matrix = new g3d_matrix();
    public g3d_matrixAnim matrixAnimation = null;
    public boolean ignore = false;
    public int type = 3;
    public static final int TYPE_MESH = 0;
    public static final int TYPE_LIGHT = 1;
    public static final int TYPE_ROOTNODE = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int TYPE_CAMERA = 4;
    public vKFFloat visibility = null;
    public float scale = 1.0f;
    public float billboardSize = 10.0f;
    public g3d_light light;
    static boolean invertnextmesh = false;
    g3d_node nNode;
    FloatBuffer modelView = null;
    FloatBuffer projView = null;
    IntBuffer viewport = null;

    public void initrandom() {
        this.randomVertex.posx = (float)Math.random() - 0.5f;
        this.randomVertex.posy = (float)Math.random() - 0.5f;
        this.randomVertex.posz = (float)Math.random() - 0.5f;
    }

    public void setMatrix(float time) {
        if (this.matrixAnimation != null) {
            this.matrixAnimation.glMulMatrix(time);
            if (this.matrixAnimation.multiplymatrices) {
                this.matrix.glMulMatrix();
            }
        } else if (this.matrix != null) {
            this.matrix.glMulMatrix();
        }
    }

    public g3d_node getPickedObj(int which) {
        int j = 0;
        while (j < this.childNodes.size()) {
            g3d_node nNode = (g3d_node)this.childNodes.get(j);
            if (nNode.pickingname == which) {
                return nNode;
            }
            ++j;
        }
        return null;
    }

    public void render(float time, g3d_material[] materials, g3d_body[] bodies, g3d_world world, boolean drawlast, int currentlight) {
        GL11.glPushMatrix();
        if (this.invert) {
            invertnextmesh = true;
        }
        if (this.type != 1 || this.type != 4) {
            this.setMatrix(time);
        }
        if (randomfloatMultiplier != 0.0f) {
            GL11.glTranslatef(this.randomVertex.posx * randomfloatMultiplier, this.randomVertex.posy * randomfloatMultiplier, this.randomVertex.posz * randomfloatMultiplier);
            this.initrandom();
        }
        if (this.replacetest) {
            GL11.glPushMatrix();
            common.scenes[this.replacescene].render();
            GL11.glPopMatrix();
        } else if (this.type == 0) {
            if (!this.depthtest) {
                GL11.glDisable(2929);
            }
            if (this.billboard && bodies[this.whichBody].getLastDrawnMaterial() >= 0) {
                if (drawlast) {
                    this.renderBillboard(materials[bodies[this.whichBody].getLastDrawnMaterial()]);
                }
            } else if (!drawlast) {
                if (invertnextmesh) {
                    GL11.glFrontFace(2304);
                }
                if (this.visibility != null) {
                    if (this.visibility.getValue(time) > 0.5f) {
                        bodies[this.whichBody].draw(time, materials);
                    }
                } else {
                    bodies[this.whichBody].draw(time, materials);
                }
                if (this.drawMarked) {
                    bodies[this.whichBody].drawDebug = true;
                    bodies[this.whichBody].draw(time, materials);
                    bodies[this.whichBody].drawDebug = false;
                }
                if (invertnextmesh) {
                    GL11.glFrontFace(2305);
                    invertnextmesh = false;
                }
                bodies[this.whichBody].temppos = this.matrix.getTranslation();
            }
        } else if (this.type == 1) {
            if (this.light == null) {
                this.light = new g3d_light();
            }
            if (this.light.g3dlightid == currentlight) {
                this.light.pos = this.matrix.getTranslation();
                this.light.set();
            }
        }
        if (this.nolight) {
            GL11.glDisable(2896);
            GL11.glDisable(3042);
            GL11.glColor3f(1.0f, 1.0f, 1.0f);
        } else {
            GL11.glEnable(2896);
        }
        int j = 0;
        while (j < this.childNodes.size()) {
            this.nNode = (g3d_node)this.childNodes.get(j);
            if (this.drawMarked) {
                this.nNode.drawMarked = true;
            }
            this.nNode.render(time, materials, bodies, world, drawlast, currentlight);
            if (this.drawMarked) {
                this.nNode.drawMarked = false;
            }
            ++j;
        }
        GL11.glPopMatrix();
    }

    public void renderBillboard(g3d_material mat) {
        if (this.modelView == null) {
            this.modelView = BufferUtils.createFloatBuffer(16);
            this.projView = BufferUtils.createFloatBuffer(16);
            this.viewport = BufferUtils.createIntBuffer(16);
        }
        GL11.glDepthMask(false);
        float ay = 0.0f;
        GL11.glGetFloat(2982, this.modelView);
        GL11.glGetFloat(2983, this.projView);
        GL11.glGetInteger(2978, this.viewport);
        g3d_vertex Right = new g3d_vertex(this.modelView.get(0), this.modelView.get(4), this.modelView.get(8));
        g3d_vertex Up = new g3d_vertex(this.modelView.get(1), this.modelView.get(5), this.modelView.get(9));
        g3d_vertex BPos = new g3d_vertex(0.0f, 0.0f, 0.0f);
        ay = BPos.posy + Right.posy + Up.posy;
        GL11.glEnable(3553);
        if (mat.texture == null) {
            System.out.println("billboard material has no texture!");
        } else {
            GL11.glBindTexture(3553, mat.texture.getID());
        }
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        GL11.glDisable(2884);
        GL11.glDisable(2896);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glPushMatrix();
        GL11.glScalef(this.billboardSize, this.billboardSize, this.billboardSize);
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(BPos.posx + Right.posx + Up.posx, BPos.posy + Right.posy + Up.posy, BPos.posz + Right.posz + Up.posz);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(BPos.posx - Right.posx + Up.posx, BPos.posy - Right.posy + Up.posy, BPos.posz - Right.posz + Up.posz);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(BPos.posx - Right.posx - Up.posx, BPos.posy - Right.posy - Up.posy, BPos.posz - Right.posz - Up.posz);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(BPos.posx + Right.posx - Up.posx, BPos.posy + Right.posy - Up.posy, BPos.posz + Right.posz - Up.posz);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable(2929);
        GL11.glDisable(3553);
        GL11.glEnable(2896);
        GL11.glDisable(3042);
        GL11.glDepthMask(true);
    }

    public void sort() {
        Collections.sort(this.childNodes, new Comparator(){

            public int compare(Object a, Object b) {
                g3d_node ia = (g3d_node)a;
                g3d_node ib = (g3d_node)b;
                if (ia.order > ib.order) {
                    return 1;
                }
                return 0;
            }
        });
        this.sorted = true;
    }

    public void loadPointCacheFiles(g3d_world world) {
        if (this.pointcachefile != null) {
            System.out.println(this.pointcachefile);
            System.out.println("whichbody:" + this.whichBody);
            System.out.println("title:" + this.title);
            if (this.whichBody == -1) {
                g3d_node np = (g3d_node)this.childNodes.get(0);
                System.out.println("child:" + np.title);
                world.bodies[np.whichBody].myPointCache = new pointcache();
                world.bodies[np.whichBody].myPointCache.load(world.bodies[np.whichBody], this.pointcachefile);
            } else {
                world.bodies[this.whichBody].myPointCache = new pointcache();
                world.bodies[this.whichBody].myPointCache.load(world.bodies[this.whichBody], this.pointcachefile);
            }
            System.out.println("has pc:" + this.title);
            System.out.println("pointcachefile:" + this.pointcachefile);
        }
        int j = 0;
        while (j < this.childNodes.size()) {
            g3d_node nNode = (g3d_node)this.childNodes.get(j);
            nNode.loadPointCacheFiles(world);
            System.out.println("___");
            ++j;
        }
    }
}

