/*
 * Decompiled with CFR 0.152.
 */
package g3d;

import g3d.g3d_vertex;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class g3d_loading {
    g3d_vertex[] points;
    g3d_vertex[] innerPoints;
    int numPoints = 36;
    float radius;
    float innerradius;
    public int loadingsteps;
    float lightcolorr = 0.8f;
    float lightcolorg = 0.8f;
    float lightcolorb = 0.8f;
    float percent = 0.0f;

    public g3d_loading() {
        this.init(1.0f, 0.8f);
    }

    g3d_loading(int r, int ir) {
        this.lightcolorr = 0.5f;
        this.lightcolorg = 0.5f;
        this.lightcolorb = 0.5f;
        this.init(r, ir);
    }

    private void init(float r, float ir) {
        this.radius = r;
        this.innerradius = ir;
        this.points = new g3d_vertex[this.numPoints + 1];
        this.innerPoints = new g3d_vertex[this.numPoints + 1];
        float full = 6.3f;
        float step = full / (float)this.numPoints;
        int pointcounter = 0;
        float i = 0.0f;
        while (i < full + step) {
            this.points[pointcounter] = new g3d_vertex();
            this.points[pointcounter].posx = (float)Math.cos(i) * this.radius;
            this.points[pointcounter].posy = (float)Math.sin(i) * this.radius;
            ++pointcounter;
            i += step;
        }
        pointcounter = 0;
        i = 0.0f;
        while (i < full + step) {
            this.innerPoints[pointcounter] = new g3d_vertex();
            this.innerPoints[pointcounter].posx = (float)Math.cos(i) * this.innerradius;
            this.innerPoints[pointcounter].posy = (float)Math.sin(i) * this.innerradius;
            ++pointcounter;
            i += step;
        }
    }

    private void pdraw(float perc) {
        GL11.glBegin(7);
        int i = 0;
        while ((float)i < (float)this.numPoints * perc) {
            GL11.glVertex3f(this.points[i].posx, this.points[i].posy, 0.0f);
            GL11.glVertex3f(this.points[i + 1].posx, this.points[i + 1].posy, 0.0f);
            GL11.glVertex3f(this.innerPoints[i + 1].posx, this.innerPoints[i + 1].posy, 0.0f);
            GL11.glVertex3f(this.innerPoints[i].posx, this.innerPoints[i].posy, 0.0f);
            ++i;
        }
        GL11.glEnd();
    }

    public void draw(float p) {
        GL11.glDisable(2896);
        GL11.glDisable(2929);
        GL11.glDisable(3553);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -30.0f);
        GL11.glRotatef(180.0f, 1.0f, 1.0f, 0.0f);
        GL11.glColor3f(0.2f, 0.2f, 0.2f);
        this.pdraw(1.0f);
        GL11.glColor3f(this.lightcolorr, this.lightcolorg, this.lightcolorb);
        this.pdraw(p);
        GL11.glEnable(2896);
    }

    public void draw() {
        GL11.glClear(16640);
        this.percent += 1.0f / (float)this.loadingsteps;
        this.draw(this.percent);
        GL11.glEnable(2929);
        Display.update();
    }
}

