/*
 * Decompiled with CFR 0.152.
 */
package g3d;

import g3d.g3d_vertex;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class g3d_bspline {
    public boolean closed = true;
    private List<g3d_vertex> points = new ArrayList<g3d_vertex>();
    private List<g3d_vertex> SmoothedPoints = new ArrayList<g3d_vertex>();
    boolean recalc = false;
    int Smooth = 2;

    public void addPoint(g3d_vertex p) {
        this.points.add(p);
        this.recalc = true;
    }

    public g3d_bspline() {
    }

    public g3d_bspline(List<g3d_vertex> _points) {
        this.points = _points;
        this.recalc = true;
    }

    public void draw() {
        if (this.recalc) {
            this.calc();
        }
        GL11.glBegin(3);
        for (g3d_vertex p : this.SmoothedPoints) {
            p.glVertex();
        }
        GL11.glEnd();
    }

    g3d_vertex getPoint(int i) {
        if (!this.closed) {
            if (i < 0) {
                return this.points.get(0);
            }
            if (i >= this.points.size()) {
                return this.points.get(this.points.size() - 1);
            }
            return this.points.get(i);
        }
        if (i < 0) {
            return this.points.get(this.points.size() + i);
        }
        if (i >= this.points.size()) {
            int a = i - this.points.size();
            return this.points.get(i - this.points.size());
        }
        return this.points.get(i);
    }

    public void calc() {
        int Segments = this.points.size();
        this.SmoothedPoints.removeAll(this.SmoothedPoints);
        try {
            int I = 0;
            while (I <= Segments - 1) {
                int J = 0;
                while (J <= this.Smooth) {
                    float F = (float)J / (float)this.Smooth;
                    g3d_vertex p = new g3d_vertex(this.Hermite(this.getPoint((int)(I - 1)).posx, this.getPoint((int)(I + 0)).posx, this.getPoint((int)(I + 1)).posx, this.getPoint((int)(I + 2)).posx, F), this.Hermite(this.getPoint((int)(I - 1)).posy, this.getPoint((int)(I + 0)).posy, this.getPoint((int)(I + 1)).posy, this.getPoint((int)(I + 2)).posy, F), this.Hermite(this.getPoint((int)(I - 1)).posz, this.getPoint((int)(I + 0)).posz, this.getPoint((int)(I + 1)).posz, this.getPoint((int)(I + 2)).posz, F));
                    this.SmoothedPoints.add(p);
                    ++J;
                }
                ++I;
            }
        }
        catch (Exception e) {
            System.out.println("calc exception:" + e);
        }
        this.recalc = false;
    }

    public float Hermite(float A, float B, float C, float D, float F) {
        float mu2 = F * F;
        float mu3 = mu2 * F;
        float m0 = (B - A + (C - B)) / 2.0f;
        float m1 = (C - B + (D - C)) / 2.0f;
        float a0 = 2.0f * mu3 - 3.0f * mu2 + 1.0f;
        float a1 = mu3 - 2.0f * mu2 + F;
        float a2 = mu3 - mu2;
        float a3 = -2.0f * mu3 + 3.0f * mu2;
        return a0 * B + a1 * m0 + a2 * m1 + a3 * C;
    }
}

