/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class GLImage {
    public static final int SIZE_BYTE = 1;
    int h = 0;
    int w = 0;
    ByteBuffer pixelBuffer = null;
    int[] pixels = null;
    Image image = null;

    public GLImage() {
    }

    public GLImage(String imgName) {
        this.loadImage(imgName);
    }

    public GLImage(ByteBuffer pixels, int w, int h) {
        this.pixelBuffer = pixels;
        this.pixels = null;
        this.image = null;
        this.h = h;
        this.w = w;
    }

    public boolean isLoaded() {
        return this.image != null;
    }

    public void flipPixels() {
        this.pixels = GLImage.flipPixels(this.pixels, this.w, this.h);
    }

    public void loadImage(String imgName) {
        Image tmpi = GLImage.loadImageFromFile(imgName);
        if (tmpi != null) {
            this.w = tmpi.getWidth(null);
            this.h = tmpi.getHeight(null);
            this.image = tmpi;
            this.pixels = this.getImagePixels();
            this.pixelBuffer = GLImage.convertImagePixels(this.pixels, this.w, this.h, true);
            System.out.println("GLImage: loaded " + imgName + ", width=" + this.w + " height=" + this.h);
        } else {
            System.out.println("GLImage: FAILED TO LOAD IMAGE " + imgName);
            this.image = null;
            this.pixels = null;
            this.pixelBuffer = null;
            this.w = 0;
            this.h = 0;
        }
    }

    public int[] getImagePixels() {
        if (this.pixels == null && this.image != null) {
            this.pixels = new int[this.w * this.h];
            PixelGrabber pg = new PixelGrabber(this.image, 0, 0, this.w, this.h, this.pixels, 0, this.w);
            try {
                pg.grabPixels();
            }
            catch (Exception e) {
                System.out.println("Pixel Grabbing interrupted!");
                return null;
            }
        }
        return this.pixels;
    }

    public int[] getPixelsARGB() {
        return this.pixels;
    }

    public ByteBuffer getPixelsRGBA() {
        return this.pixelBuffer;
    }

    public static int[] flipPixels(int[] imgPixels, int imgw, int imgh) {
        int[] flippedPixels = null;
        if (imgPixels != null) {
            flippedPixels = new int[imgw * imgh];
            int y = 0;
            while (y < imgh) {
                int x = 0;
                while (x < imgw) {
                    flippedPixels[(imgh - y - 1) * imgw + x] = imgPixels[y * imgw + x];
                    ++x;
                }
                ++y;
            }
        }
        return flippedPixels;
    }

    public static ByteBuffer convertImagePixels(int[] jpixels, int imgw, int imgh, boolean flipVertically) {
        if (flipVertically) {
            jpixels = GLImage.flipPixels(jpixels, imgw, imgh);
        }
        byte[] bytes = GLImage.convertARGBtoRGBA(jpixels);
        return GLImage.allocBytes(bytes);
    }

    public static byte[] convertARGBtoRGBA(int[] jpixels) {
        byte[] bytes = new byte[jpixels.length * 4];
        int j = 0;
        int i = 0;
        while (i < jpixels.length) {
            boolean outPixel = false;
            int p = jpixels[i];
            int a = p >> 24 & 0xFF;
            int r = p >> 16 & 0xFF;
            int g = p >> 8 & 0xFF;
            int b = p >> 0 & 0xFF;
            bytes[j + 0] = (byte)r;
            bytes[j + 1] = (byte)g;
            bytes[j + 2] = (byte)b;
            bytes[j + 3] = (byte)a;
            j += 4;
            ++i;
        }
        return bytes;
    }

    public static ByteBuffer allocBytes(byte[] bytearray) {
        ByteBuffer bb = ByteBuffer.allocateDirect(bytearray.length * 1).order(ByteOrder.nativeOrder());
        bb.put(bytearray).flip();
        return bb;
    }

    public static Image loadImageFromFile(String imgName) {
        byte[] imageBytes = GLImage.getBytesFromFile(imgName);
        Image tmpi = null;
        int numTries = 20;
        if (imageBytes != null) {
            tmpi = Toolkit.getDefaultToolkit().createImage(imageBytes, 0, imageBytes.length);
            while (tmpi.getWidth(null) < 0 && numTries-- > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    System.out.println(e);
                }
            }
            while (tmpi.getHeight(null) < 0 && numTries-- > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    System.out.println(e);
                }
            }
        }
        return tmpi;
    }

    public static byte[] getBytesFromFile(String filename) {
        File f = new File(filename);
        byte[] bytes = null;
        if (f.exists()) {
            try {
                bytes = GLImage.getBytesFromFile(f);
            }
            catch (Exception e) {
                System.out.println("getBytesFromFile() exception: " + e);
            }
        }
        return bytes;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        byte[] bytes = null;
        if (file != null) {
            FileInputStream is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                System.out.println("getBytesFromFile() error: File " + file.getName() + " is too large");
            } else {
                bytes = new byte[(int)length];
                int offset = 0;
                int numRead = 0;
                while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
                    offset += numRead;
                }
                if (offset < bytes.length) {
                    throw new IOException("getBytesFromFile() error: Could not completely read file " + file.getName());
                }
            }
            ((InputStream)is).close();
        }
        return bytes;
    }
}

