/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.EventQueue;
import org.lwjgl.opengl.WindowsDirectInput;
import org.lwjgl.opengl.WindowsDirectInputDevice;
import org.lwjgl.opengl.WindowsDirectInputDeviceObjectCallback;

final class WindowsDirectInputMouse {
    private static final int BUFFER_SIZE = 50;
    private static final int BUTTON_STATES_SIZE = 7;
    private static final int DIMOFS_X = 0;
    private static final int DIMOFS_Y = 4;
    private static final int DIMOFS_Z = 8;
    private static final int DIMOFS_BUTTON0 = 12;
    private static final int DIMOFS_BUTTON1 = 13;
    private static final int DIMOFS_BUTTON2 = 14;
    private static final int DIMOFS_BUTTON3 = 15;
    private final long hwnd;
    private final WindowsDirectInput dinput;
    private final WindowsDirectInputDevice mouse;
    private final int mouse_button_count;
    private final boolean has_wheel;
    private final EventQueue event_queue = new EventQueue(22);
    private final ByteBuffer mouse_state;
    private final IntBuffer temp_data_buffer;
    private final ByteBuffer mouse_event = ByteBuffer.allocate(22);
    private boolean mouse_grabbed;
    private byte[] win32_message_button_states = new byte[7];
    private int accum_dwheel;
    private int last_x;
    private int last_y;

    public WindowsDirectInputMouse(WindowsDirectInput dinput, long hwnd) throws LWJGLException {
        this.hwnd = hwnd;
        this.dinput = dinput;
        try {
            this.mouse = dinput.createDevice(2);
            try {
                this.mouse.setDataFormat(2);
                this.mouse.setBufferSize(50);
                if (!this.acquireNonExclusive()) {
                    throw new LWJGLException("Failed to acquire mouse non-exclusive");
                }
            }
            catch (LWJGLException e) {
                this.mouse.release();
                throw e;
            }
        }
        catch (LWJGLException e) {
            dinput.release();
            throw e;
        }
        MouseEnumerator enumerator = new MouseEnumerator();
        this.mouse.enumObjects(enumerator);
        this.mouse_button_count = Math.min(enumerator.getButtonCount(), 4);
        this.has_wheel = enumerator.hasWheel();
        this.mouse_state = BufferUtils.createByteBuffer(16);
        this.temp_data_buffer = BufferUtils.createIntBuffer(150);
    }

    public boolean hasWheel() {
        return this.has_wheel;
    }

    public int getButtonCount() {
        return this.mouse_button_count;
    }

    private boolean acquire(int flags) {
        try {
            this.mouse.setCooperateLevel(this.hwnd, flags);
            this.mouse.acquire();
            return true;
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Failed to acquire mouse: " + e);
            return false;
        }
    }

    private boolean acquireNonExclusive() {
        return this.acquire(6) || this.acquire(10);
    }

    public void destroy() {
        this.mouse.unacquire();
        this.mouse.release();
        this.dinput.release();
    }

    public void poll(IntBuffer coord_buffer, ByteBuffer buttons) {
        int ret = this.mouse.acquire();
        if (ret != 0 && ret != 1) {
            return;
        }
        this.mouse.poll();
        for (int i = 0; i < coord_buffer.remaining(); ++i) {
            coord_buffer.put(coord_buffer.position() + i, 0);
        }
        this.mouse_state.clear();
        ret = this.mouse.getDeviceState(this.mouse_state);
        int mouse_state_lx = this.mouse_state.getInt();
        int mouse_state_ly = this.mouse_state.getInt();
        int mouse_state_lz = this.mouse_state.getInt();
        int num_buttons = this.mouse_button_count;
        if (this.mouse_grabbed || ret == 0) {
            if (ret != 0) {
                LWJGLUtil.log("Error getting mouse state: (0x" + Integer.toHexString(ret) + ")");
                return;
            }
            coord_buffer.put(coord_buffer.position() + 2, mouse_state_lz);
            if (num_buttons > buttons.remaining()) {
                num_buttons = buttons.remaining();
            }
            for (int j = 0; j < num_buttons; ++j) {
                byte button_state = (this.mouse_state.get() & 0x80) != 0 ? (byte)1 : 0;
                buttons.put(buttons.position() + j, button_state);
                this.win32_message_button_states[j] = button_state;
            }
        } else {
            coord_buffer.put(coord_buffer.position() + 2, this.accum_dwheel);
            if (num_buttons > this.win32_message_button_states.length) {
                num_buttons = this.win32_message_button_states.length;
            }
            for (int j = 0; j < num_buttons; ++j) {
                buttons.put(buttons.position() + j, this.win32_message_button_states[j]);
            }
        }
        this.accum_dwheel = 0;
        if (this.mouse_grabbed) {
            coord_buffer.put(coord_buffer.position() + 0, mouse_state_lx);
            coord_buffer.put(coord_buffer.position() + 1, -mouse_state_ly);
        } else {
            coord_buffer.put(coord_buffer.position() + 0, this.last_x);
            coord_buffer.put(coord_buffer.position() + 1, this.last_y);
        }
    }

    private void putMouseEventWithCoords(byte button, byte state, int coord1, int coord2, int dz, long nanos) {
        this.mouse_event.clear();
        this.mouse_event.put(button).put(state).putInt(coord1).putInt(coord2).putInt(dz).putLong(nanos);
        this.mouse_event.flip();
        this.event_queue.putEvent(this.mouse_event);
    }

    private void putMouseEvent(byte button, byte state, int dz, long nanos) {
        if (this.mouse_grabbed) {
            this.putMouseEventWithCoords(button, state, 0, 0, dz, nanos);
        } else {
            this.putMouseEventWithCoords(button, state, this.last_x, this.last_y, dz, nanos);
        }
    }

    private void copyDXEvents(IntBuffer buffer) {
        boolean buffer_index = false;
        int dx = 0;
        int dy = 0;
        int dwheel = 0;
        long nanos = 0L;
        while (buffer.hasRemaining()) {
            int dwOfs = buffer.get();
            int dwData = buffer.get();
            long dwTimeStamp = (long)buffer.get() & 0xFFFFFFFFFFFFFFFFL;
            nanos = dwTimeStamp * 1000000L;
            byte button_state = (dwData & 0x80) != 0 ? (byte)1 : 0;
            switch (dwOfs) {
                case 12: {
                    this.putMouseEventWithCoords((byte)0, button_state, dx, -dy, dwheel, nanos);
                    dwheel = 0;
                    dy = 0;
                    dx = 0;
                    break;
                }
                case 13: {
                    this.putMouseEventWithCoords((byte)1, button_state, dx, -dy, dwheel, nanos);
                    dwheel = 0;
                    dy = 0;
                    dx = 0;
                    break;
                }
                case 14: {
                    this.putMouseEventWithCoords((byte)2, button_state, dx, -dy, dwheel, nanos);
                    dwheel = 0;
                    dy = 0;
                    dx = 0;
                    break;
                }
                case 15: {
                    this.putMouseEventWithCoords((byte)3, button_state, dx, -dy, dwheel, nanos);
                    dwheel = 0;
                    dy = 0;
                    dx = 0;
                    break;
                }
                case 0: {
                    dx += dwData;
                    break;
                }
                case 4: {
                    dy += dwData;
                    break;
                }
                case 8: {
                    dwheel += dwData;
                }
            }
        }
        if (dx != 0 || dy != 0 || dwheel != 0) {
            this.putMouseEventWithCoords((byte)-1, (byte)0, dx, -dy, dwheel, nanos);
        }
    }

    private void readDXBuffer() {
        int ret = this.mouse.acquire();
        if (ret != 0 && ret != 1) {
            return;
        }
        this.mouse.poll();
        this.temp_data_buffer.clear();
        ret = this.mouse.getDeviceData(this.temp_data_buffer);
        switch (ret) {
            case 0: {
                break;
            }
            case 1: {
                LWJGLUtil.log("Mouse buffer overflowed");
                break;
            }
            case -2147024866: {
                LWJGLUtil.log("Mouse input lost");
                break;
            }
            case -2147024868: {
                LWJGLUtil.log("Mouse not acquired");
                break;
            }
            default: {
                LWJGLUtil.log("unknown mouse error (" + Integer.toHexString(ret) + ")");
            }
        }
    }

    public final void flush() {
        this.readDXBuffer();
        this.temp_data_buffer.clear();
    }

    public void read(ByteBuffer buffer) {
        this.readDXBuffer();
        if (this.mouse_grabbed) {
            this.temp_data_buffer.flip();
            this.copyDXEvents(this.temp_data_buffer);
        }
        this.event_queue.copyEvents(buffer);
    }

    public void grab(boolean grab) {
        if (grab) {
            if (!this.mouse_grabbed) {
                this.flush();
                this.mouse_grabbed = true;
                this.mouse.unacquire();
                if (!this.acquire(5)) {
                    LWJGLUtil.log("Failed to reset cooperative mode");
                }
            }
        } else if (this.mouse_grabbed) {
            this.mouse_grabbed = false;
            this.mouse.unacquire();
            this.acquireNonExclusive();
        }
        this.event_queue.clearEvents();
    }

    public void handleMouseScrolled(int event_dwheel, long millis) {
        this.accum_dwheel += event_dwheel;
        this.putMouseEvent((byte)-1, (byte)0, event_dwheel, millis * 1000000L);
    }

    public void handleMouseMoved(int x, int y, long millis) {
        int dx = x - this.last_x;
        int dy = y - this.last_y;
        this.last_x = x;
        this.last_y = y;
        long nanos = millis * 1000000L;
        if (this.mouse_grabbed) {
            this.putMouseEventWithCoords((byte)-1, (byte)0, dx, dy, 0, nanos);
        } else {
            this.putMouseEventWithCoords((byte)-1, (byte)0, x, y, 0, nanos);
        }
    }

    public void handleMouseButton(byte button, byte state, long millis) {
        this.putMouseEvent(button, state, 0, millis * 1000000L);
        if (button < 7) {
            this.win32_message_button_states[button] = state != 0 ? (byte)1 : 0;
        }
    }

    private static class MouseEnumerator
    implements WindowsDirectInputDeviceObjectCallback {
        private int button_count;
        private boolean has_wheel;

        private MouseEnumerator() {
        }

        public int getButtonCount() {
            return this.button_count;
        }

        public boolean hasWheel() {
            return this.has_wheel;
        }

        public boolean nextObject(int type, String name) {
            LWJGLUtil.log("Found mouse object: " + name);
            switch (type) {
                case 3: {
                    this.has_wheel = true;
                    break;
                }
                case 4: {
                    ++this.button_count;
                    break;
                }
            }
            return true;
        }
    }
}

