// Wireframe rendering

float4x4 	wMatrix   : World;
float4x4  	vMatrix   : View;
float4x4  	pMatrix   : Projection;
float3		wireColor
<
	string UIName = "Wire Color";
> = { 1.0f, 0.0f, 0.0f };

struct VertexOutput
{
	float4 position	: POSITION;
	float3 color	: COLOR;
};

VertexOutput VS_Wireframe(float4 position : POSITION) {
    VertexOutput OUT;
    
    float4x4 finalMatrix = mul( wMatrix, vMatrix );
    finalMatrix = mul( finalMatrix, pMatrix );
    OUT.position = mul( position, finalMatrix );
    OUT.color = wireColor;
    
    return OUT;
}

technique Wireframe
{
    pass p0
    {		
		VertexShader = compile vs_2_0 VS_Wireframe();
		PixelShader = NULL;
		
		FillMode = wireframe;
		ColorVertex = true;
    }
}