// Per-Pixel diffuse lighting

float4x4	worldMatrix				: World;
float4x4 	worldViewProjMatrix 	: WorldViewProjection;
float4 		lightPos				: Light0;
float		time					: Time;
float3		diffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 1.0f, 1.0f, 1.0f };

struct VertexInput {
    float3 Position	: POSITION;
    float3 Normal	: NORMAL;
};

struct VertexOutput
{
    float4 HPosition	: POSITION;
    half3 lightDir		: TEXCOORD0;
    half3 worldNormal	: TEXCOORD1;
    float lenPos		: TEXCOORD2;
};

VertexOutput VS_Diffuse(VertexInput IN) {
    VertexOutput OUT;
    
    float3 worldPos = mul(float4(IN.Position,1.0f), worldMatrix);
    half3 worldNormal = mul(IN.Normal, worldMatrix);
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.HPosition = mul(float4(IN.Position,1.0f), worldViewProjMatrix);
    OUT.lenPos = length(IN.Position);
    return OUT;
}

float4 PS_Diffuse( VertexOutput IN ) : COLOR
{
	half3 normal =  normalize(IN.worldNormal);
	half3 lightDir = normalize(IN.lightDir);
	float dif = max(0,dot( normal, lightDir ));
	float mulFactor = pow(dif,6.0f)*1.5f*(0.2f+0.4f*sin(IN.lenPos*0.1f+time*1.8f)+pow(cos(1.0f/IN.lenPos*0.4f),2));
	return float4(mulFactor * float3(0.3,0.4,0.6),1.0f);
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse();
		PixelShader = compile ps_2_0 PS_Diffuse();
		ZWriteEnable = false;
		ZEnable = false;
    }
}