// Per-Pixel diffuse lighting

float4x4	worldMatrix				: World;
float4x4 	worldViewProjMatrix 	: WorldViewProjection;
float4x4	vpMatrix 				: ViewProjection;
float4 		lightPos				: Light1;
float		time					: Time;

texture texture_0;
sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 Position	: POSITION;
    float3 Normal	: NORMAL;
    float2 toCurve	: TEXCOORD1;
};

struct VertexOutput {
    float4 position	: POSITION;
    float3 color	: COLOR;
};

struct VertexOutput_ps20
{
    float4 HPosition	: POSITION;
    float4 color		: TEXCOORD1;
};

VertexOutput_ps20 VS_Diffuse_ps20(VertexInput IN) {
    VertexOutput_ps20 OUT;
    
    float simVar = (0.8+0.4*cos(time*2.0f+length(IN.Position)*0.5f));
    IN.Position += simVar*IN.Normal;
    OUT.HPosition = mul(float4(IN.Position,1.0f), worldViewProjMatrix);
    OUT.color = float4( 0.4f, 0.5f, 0.9f, exp(-50*abs(time*0.25f-IN.toCurve.y) ));
    return OUT;
}

float4 PS_Diffuse( VertexOutput_ps20 IN ) : COLOR
{
	float alphaTerm = tex2D( texture_0Sampler, IN.color.a );
	clip( alphaTerm - 0.001f );
	return float4(IN.color.rgb, alphaTerm);
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse_ps20();
		PixelShader = compile ps_2_0 PS_Diffuse();
		
		AlphaBlendEnable = true;
		srcBlend = srcAlpha;
		destBlend = invSrcAlpha;
		ZWriteEnable = false;
    }
}