float4x4 	wvpMatrix 	: WorldViewProjection;

float3		color1
<
	string UIName = "Ambient Material Color";
> = { 0.4f, 0.4f, 0.4f };

float3		color2
<
	string UIName = "Ambient Material Color";
> = { 0.6f, 0.75f, 1.0f };

float		ColA = 1.0f;

struct VertexInput {
    float3 Position	: POSITION;
};

struct VertexOutput {
    float4 position	: POSITION;
    float3 color	: COLOR;
};

VertexOutput VS_Ambient(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.position = mul(float4(IN.Position,1.0f), wvpMatrix);
	OUT.color = lerp(color1,color2,ColA);
    return OUT;
}

technique fixed
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Ambient();
		PixelShader = NULL;
		
		ColorVertex = true;
    }
}


