// Per-Pixel diffuse lighting

float4x4	worldMatrix				: World;
float4x4 	worldViewProjMatrix 	: WorldViewProjection;
float4x4	vpMatrix 				: ViewProjection;
float2		screen					: Screen;
float3		diffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 1.0f, 1.0f, 1.0f };

float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 0.0f, 0.0f, 0.0f };

texture	texture_0
<
	string UIName = "Base texture";
>;

sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 Position	: POSITION;
    float2 uvCoord	: TEXCOORD0;
};

struct VertexOutput_ps20
{
    float4 Position	: POSITION;
    float2 uvCoord	: TEXCOORD0;
};

VertexOutput_ps20 VS_Diffuse_ps20(VertexInput IN) {
    VertexOutput_ps20 OUT;
    
    OUT.Position = mul(float4(IN.Position,1.0f), worldViewProjMatrix);
    OUT.uvCoord = (0.5f*(float2(OUT.Position.x,-OUT.Position.y))/OUT.Position.w+0.5f);
    return OUT;
}

float4 PS_Diffuse( VertexOutput_ps20 IN ) : COLOR
{
	float3 color = tex2D( texture_0Sampler, IN.uvCoord );
	return (1.0f-(color.x+color.y+color.z)*0.6f)*float4(1.0f, 0.973f, 0.684f, 1.0f);
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse_ps20();
		PixelShader = compile ps_2_0 PS_Diffuse();
		
		ZWriteEnable = false;
    }
}