float4x4 	wvpMatrix 	: WorldViewProjection;
float		time		: Time;
float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 1.0f, 1.0f, 1.0f };

struct VertexInput {
    float3 Position	: POSITION;
    float3 color	: TEXCOORD1;
};

struct VertexOutput {
    float4 position	: POSITION;
    float3 color	: COLOR;
};

VertexOutput VS_Ambient(VertexInput IN) {
    VertexOutput OUT;
    
    IN.Position.y += time*15.0f;
    IN.Position += float3(IN.Position.x,0.0f,IN.Position.z)*sin(time+IN.Position.y*0.1f)*0.35f;
    OUT.position = mul(float4(IN.Position,1.0f), wvpMatrix);
	OUT.color = IN.color;
    return OUT;
}


technique glow<bool quad=true; string material="gaussian";>
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Ambient();
		PixelShader = NULL;
		
		ColorVertex = true;
    }
}

technique fixed
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Ambient();
		PixelShader = NULL;
		
		ColorVertex = true;
    }
}


