// Per-Pixel diffuse lighting

float4x4	worldMatrix				: World;
float4x4 	worldViewProjMatrix 	: WorldViewProjection;
float4x4	vpMatrix 				: ViewProjection;
float4 		lightPos				: Light0;
float2		screenSize				: Screen;
float		time					: Time;
float3		diffuseColor1
<
	string UIName = "Diffuse Material Color";
> = { 0.6f, 0.6f, 0.6f };

float3		ambientColor1
<
	string UIName = "Ambient Material Color";
> = { 0.1f, 0.1f, 0.1f };

float3		diffuseColor2
<
	string UIName = "Diffuse Material Color";
> = { 0.6f, 0.6f, 0.6f };

float3		ambientColor2
<
	string UIName = "Ambient Material Color";
> = { 0.1f, 0.1f, 0.1f };

float		ColA = 1.0f;
texture texture_0;
texture texture_1;
texture texture_2;
texture texture_3;

sampler texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = NONE;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};
sampler texture_1Sampler = sampler_state 
{
    texture = <texture_1>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = NONE;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};
sampler texture_2Sampler = sampler_state 
{
    texture = <texture_2>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = NONE;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};
sampler texture_3Sampler = sampler_state 
{
    texture = <texture_3>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = POINT;
    MINFILTER = POINT;
    MAGFILTER = POINT;
};

struct VertexInput {
    float3 Position	: POSITION;
    float3 Normal	: NORMAL;
    float3 Color	: TEXCOORD1;
};

struct VertexOutput {
    float4 position	: POSITION;
    float3 color	: COLOR;
};

struct VertexOutput_ps20
{
    float4 HPosition	: POSITION;
    half3 lightDir		: TEXCOORD0;
    half3 worldNormal	: TEXCOORD1;
    float3 Color		: TEXCOORD2;
};

VertexOutput_ps20 VS_Diffuse_ps20(VertexInput IN) {
    VertexOutput_ps20 OUT;
    
    float3 worldPos = mul(float4(IN.Position,1.0f), worldMatrix);
    float dist = length(IN.Position);
    half3 worldNormal = mul(IN.Normal, worldMatrix);
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.HPosition = mul(float4(IN.Position,1.0f), worldViewProjMatrix);
    IN.Color.r = 1.0f;
    OUT.Color = IN.Color*(min(1.0f, 86.0f+dist-time*0.7));
    return OUT;
}

float4 PS_Diffuse( VertexOutput_ps20 IN ) : COLOR
{
	half3 normal =  normalize(IN.worldNormal);
	half3 lightDir = normalize(IN.lightDir);
	float diffuseTerm = max(0,dot( normal, lightDir ));
	diffuseTerm+=0.3f;
	diffuseTerm = pow(diffuseTerm,0.6f);
	float3 finalColor = diffuseTerm * IN.Color + float3(0.2f, 0.2f, 0.2f);
	return float4(float3(finalColor.r,finalColor.g,finalColor.b),1.0f);
}


technique ps20<bool quad=true; string material="blur";>
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse_ps20();
		PixelShader = compile ps_2_0 PS_Diffuse();
    }
}

struct VertexInput_quad {
    float3 Position	: POSITION;
    float2 uvCoord	: TEXCOORD0;
};

struct VertexOutput_quad {
    float4 Position	: POSITION;
    float4 uvCoord	: TEXCOORD0;
    float2 uvNoise	: TEXCOORD1;
};
VertexOutput_quad QuadProjection(VertexInput_quad IN) {
    VertexOutput_quad OUT;
    
    OUT.Position = mul( float4(IN.Position,1.0f), worldViewProjMatrix );
    OUT.uvCoord = OUT.Position;//(0.5f*(float2(OUT.Position.x,-OUT.Position.y))/OUT.Position.w+0.5f);
    OUT.uvNoise = IN.uvCoord*16.0f;
    
    return OUT;
}
float4 Combination( VertexOutput_quad IN ) : COLOR
{
	float3 noiseColor = tex2D( texture_3Sampler, IN.uvNoise );
	float2 uvCoord = (0.5f*(float2(IN.uvCoord.x,-IN.uvCoord.y))/IN.uvCoord.w+0.5f);
	uvCoord += float2(noiseColor.x, noiseColor.y)*0.003f;
	float3 combo = (tex2D( texture_0Sampler, uvCoord ) +
			tex2D( texture_1Sampler, uvCoord ) +
			tex2D( texture_2Sampler, uvCoord ))*0.3333f;
			
	float3 col1 = float3(combo.b,combo.b,combo.b);
	float3 col2 = float3(combo.b*1.3f,combo.b*1.2f,combo.b*0.9f);
	return float4(lerp(col1,col2,ColA),combo.r-0.15f);
}

technique Combine
{
    pass p0 
    {		
		VertexShader = compile vs_2_0 QuadProjection();
		PixelShader = compile ps_2_0 Combination();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = srcAlpha;
		destBlend =invsrcAlpha;
    }
}