float4x4 	wvpMatrix 	: WorldViewProjection;
float		time		: Time;
texture	texture_0
<
	string UIName = "Base texture";
>;

struct VertexInput {
    float3 position	: POSITION;
    float2 uvCoords	: TEXCOORD0;
};

struct VertexOutput {
    float4 position	: POSITION;
    float2 uvCoords	: TEXCOORD0;
};

VertexOutput VS_Ambient(VertexInput IN) {
    VertexOutput OUT;
    
    IN.position = 5.0f*IN.position;
    float sinTime = sin(time*7.0f)*1.5f+0.2f;
    IN.position.z = sin(sinTime)*(pow(abs(IN.position.x),1.4f)*(0.2f+abs(IN.position.y)*0.07f)-0.5f);
    IN.position.x = IN.position.x*(0.4f+cos(sinTime)*0.6f);
    IN.position = 0.2f*IN.position;
    OUT.position = mul(float4(IN.position,1.0f), wvpMatrix);
	OUT.uvCoords = IN.uvCoords;
    return OUT;
}

technique fixed
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Ambient();
		PixelShader = NULL;
		
		ColorVertex = true;
		CullMode = none;
		
		texture[0] = <texture_0>;
		mipfilter[0] = LINEAR;
		minfilter[0] = LINEAR;
		magfilter[0] = LINEAR;
		
		ColorOp[0]	 = SelectArg1;
		colorArg1[0] = Texture;
		
		ZFunc =lessequal;
    }
}
