float4x4	wMatrix			: World;
float4x4 	wvpMatrix 		: WorldViewProjection;
float4 		lightPos		: Light0;
float		time			: Time;
float3		diffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 1.0f, 1.0f, 1.0f };

float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 0.0f, 0.0f, 0.0f };
float		lerpValue = 0.0f;

texture	texture_0
<
	string UIName = "Base texture";
>;

sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 position		: POSITION;
    float3 Normal		: NORMAL;
    float2 uvCoord		: TEXCOORD0;
    float2 toCurve		: TEXCOORD1;
};

struct VertexOutput {
    float4 	position	: POSITION;
    half3 	lightDir	: TEXCOORD0;
    half3 	worldNormal	: TEXCOORD1;
    float2	uvCoord		: TEXCOORD2;
    float	lerpValue	: TEXCOORD3;
};

VertexOutput VS_Diffuse(VertexInput IN) {
    VertexOutput OUT;
    
    float3 worldPos = mul(float4(IN.position,1.0f), wMatrix);
    half3 worldNormal = mul(IN.Normal, wMatrix);
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.position = mul(float4(IN.position,1.0f), wvpMatrix);
	OUT.uvCoord = IN.uvCoord;
	OUT.lerpValue = min(1.0f,max(0.0f,-32.0f-IN.toCurve.x*20.0f+time*0.4f));
    return OUT;
}

float4 PS_Diffuse( VertexOutput IN ) : COLOR
{
	half3 normal =  normalize(IN.worldNormal);
	half3 lightDir = normalize(IN.lightDir);
	float4 col1 = tex2D( texture_0Sampler, IN.uvCoord );
	float4 col2 = col1.bgra;
	float4 finalCol = lerp(col1,col2,lerpValue);
	float4 monCol = (finalCol.r+finalCol.g+finalCol.b)*0.3333f;
	monCol.a = 1.0f;
	return float4(max(0,dot( normal, lightDir )) * diffuseColor + ambientColor,1.0f) * lerp(monCol, finalCol, IN.lerpValue);
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_2_0 VS_Diffuse();
		PixelShader = compile ps_2_0 PS_Diffuse();
    }
}

