float4x4 	wvpMatrix 	: WorldViewProjection;
float		ColA;
float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 1.0f, 1.0f, 1.0f };

struct VertexInput {
    float3 Position	: POSITION;
};

struct VertexOutput {
    float4 position	: POSITION;
    float4 color	: COLOR;
};

VertexOutput VS_Ambient(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.position = float4(IN.Position*1.1f,1.0f);
    OUT.color = float4(ambientColor,ColA);
    return OUT;
}

technique fixed
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Ambient();
		PixelShader = NULL;
		
		AlphaBlendEnable =true;
		destBlend = invSrcAlpha;
		srcBlend = srcAlpha;
		ZEnable = false;
		ZWriteEnable = false;
		ColorVertex = true;
    }
}


