/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.devil;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.devil.IL;
import org.lwjgl.devil.ILU;
import org.lwjgl.devil.ILUT;

class ILNative {
    private static String JNI_LIBRARY_NAME = "lwjgl-devil";
    static final String VERSION = "1.1.3";
    static final int JNI_VERSION = 2;

    ILNative() {
    }

    private static void loadLibrary(final String lib_name) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String library_path = System.getProperty("org.lwjgl.librarypath");
                if (library_path != null) {
                    System.load(library_path + File.separator + System.mapLibraryName(lib_name));
                } else {
                    System.loadLibrary(lib_name);
                }
                return null;
            }
        });
    }

    static native void initNativeStubsIL(Class var0) throws LWJGLException;

    static native void resetNativeStubsIL(Class var0);

    static native void nCreateIL(String[] var0) throws LWJGLException;

    static native void nDestroyIL();

    private static native int getNativeLibraryVersion();

    static void createIL() throws LWJGLException {
        String platform_libname;
        String libname;
        switch (LWJGLUtil.getPlatform()) {
            case 3: {
                libname = "DevIL";
                platform_libname = "DevIL.dll";
                break;
            }
            case 1: {
                libname = "IL";
                platform_libname = "libIL.so";
                break;
            }
            case 2: {
                libname = "IL";
                platform_libname = "libIL.dylib";
                break;
            }
            default: {
                throw new LWJGLException("Unknown platform: " + LWJGLUtil.getPlatform());
            }
        }
        String[] illPaths = LWJGLUtil.getLibraryPaths((String)libname, (String)platform_libname, (ClassLoader)IL.class.getClassLoader());
        ILNative.nCreateIL(illPaths);
        try {
            ILNative.initNativeStubsIL(IL.class);
            IL.ilInit();
        }
        catch (LWJGLException e) {
            IL.destroy();
            throw e;
        }
    }

    public static void destroyIL() {
        ILNative.resetNativeStubsIL(IL.class);
        ILNative.nDestroyIL();
    }

    static native void initNativeStubsILU(Class var0) throws LWJGLException;

    static native void resetNativeStubsILU(Class var0);

    static native void nCreateILU(String[] var0) throws LWJGLException;

    static native void nDestroyILU();

    static void createILU() throws LWJGLException {
        String libname;
        switch (LWJGLUtil.getPlatform()) {
            case 3: {
                libname = "ILU.dll";
                break;
            }
            case 1: {
                libname = "libILU.so";
                break;
            }
            case 2: {
                libname = "libILU.dylib";
                break;
            }
            default: {
                throw new LWJGLException("Unknown platform: " + LWJGLUtil.getPlatform());
            }
        }
        String[] iluPaths = LWJGLUtil.getLibraryPaths((String)"ILU", (String)libname, (ClassLoader)ILU.class.getClassLoader());
        ILNative.nCreateILU(iluPaths);
        try {
            ILNative.initNativeStubsILU(ILU.class);
            ILU.iluInit();
        }
        catch (LWJGLException e) {
            ILU.destroy();
            throw e;
        }
    }

    public static void destroyILU() {
        ILNative.resetNativeStubsILU(ILU.class);
        ILNative.nDestroyILU();
    }

    static native void initNativeStubsILUT(Class var0) throws LWJGLException;

    static native void resetNativeStubsILUT(Class var0);

    static native void nCreateILUT(String[] var0) throws LWJGLException;

    static native void nDestroyILUT();

    static void createILUT() throws LWJGLException {
        String libname;
        switch (LWJGLUtil.getPlatform()) {
            case 3: {
                libname = "ILUT.dll";
                break;
            }
            case 1: {
                libname = "libILUT.so";
                break;
            }
            case 2: {
                libname = "libILUT.dylib";
                break;
            }
            default: {
                throw new LWJGLException("Unknown platform: " + LWJGLUtil.getPlatform());
            }
        }
        String[] ilutPaths = LWJGLUtil.getLibraryPaths((String)"ILUT", (String)libname, (ClassLoader)ILUT.class.getClassLoader());
        ILNative.nCreateILUT(ilutPaths);
        try {
            ILNative.initNativeStubsILUT(ILUT.class);
            ILUT.ilutInit();
        }
        catch (LWJGLException e) {
            ILUT.destroy();
            throw e;
        }
    }

    public static void destroyILUT() {
        ILNative.resetNativeStubsILUT(ILUT.class);
        ILNative.nDestroyILUT();
    }

    static {
        ILNative.loadLibrary(JNI_LIBRARY_NAME);
        int nativeVersion = ILNative.getNativeLibraryVersion();
        if (nativeVersion != 2) {
            throw new LinkageError("Version mismatch: jar version is '2', native libary version is '" + nativeVersion + "'");
        }
    }
}

