/*
 * Decompiled with CFR 0.152.
 */
package org.jouvieje.Fmod;

import org.jouvieje.Fmod.Exceptions.InitException;
import org.jouvieje.Fmod.FmodJNI;

public class Init {
    protected static boolean fmodLibrariesLoaded = false;
    protected static boolean fmodDynLibrariesLoaded = false;
    protected static int initMode = -1;

    private Init() {
    }

    public static void loadLibraries() throws InitException {
        Init.loadLibraries(1);
    }

    public static void loadLibraries(int n) throws InitException {
        switch (n) {
            case 0: 
            case 1: {
                Init.loadFmod();
                fmodLibrariesLoaded = true;
                initMode = 1;
                break;
            }
            case 2: {
                Init.loadFmod();
                Init.loadFmodDyn();
                fmodLibrariesLoaded = true;
                fmodDynLibrariesLoaded = true;
                initMode = 2;
            }
        }
    }

    private static void loadFmod() throws InitException {
        try {
            System.loadLibrary("fmod");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary("fmod-3.75");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                try {
                    System.loadLibrary("fmodce");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                    // empty catch block
                }
            }
        }
        try {
            System.loadLibrary("NativeFmod");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary("NativeFmodCe");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError4) {
                System.err.println(unsatisfiedLinkError.getMessage());
                System.err.println(unsatisfiedLinkError4.getMessage());
                throw new InitException("NativeFmod library not found : NativeFmod.dll, libNativeFmod.so, libNativeFmod.jnilib or NativeFmodCe.dll");
            }
        }
        if (FmodJNI.get_PLATFORM() == 0 || FmodJNI.get_PLATFORM() == 1) {
            try {
                System.loadLibrary("fmod");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println(unsatisfiedLinkError.getMessage());
                throw new InitException("FMOD library not found : fmod.dll");
            }
        }
        if (FmodJNI.get_PLATFORM() == 2 || FmodJNI.get_PLATFORM() == 8) {
            try {
                System.loadLibrary("fmod-3.75");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println(unsatisfiedLinkError.getMessage());
                throw new InitException("FMOD library not found : libfmod-3.75.so");
            }
        }
        if (FmodJNI.get_PLATFORM() == 7) {
            try {
                System.loadLibrary("fmodce");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println(unsatisfiedLinkError.getMessage());
                throw new InitException("FMOD library not found : fmodce.dll");
            }
        }
    }

    private static void loadFmodDyn() throws InitException {
        try {
            if (FmodJNI.get_PLATFORM() == 7) {
                System.loadLibrary("NativeFmodDynCe");
            } else {
                System.loadLibrary("NativeFmodDyn");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(unsatisfiedLinkError.getMessage());
            throw new InitException("NativeFmod library not found : NativeFmodDyn.dll, NativeFmodDynCe.dll or libNativeFmodDyn.so");
        }
    }

    public static boolean isFmodLibrariesLoaded() {
        return fmodLibrariesLoaded;
    }

    public static boolean isFmodDynLibrariesLoaded() {
        return fmodLibrariesLoaded;
    }

    public static int getInitMode() {
        return initMode;
    }
}

