/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Color;
import idx3d.idx3d_FXPlugin;
import idx3d.idx3d_Math;
import idx3d.idx3d_Object;
import idx3d.idx3d_Scene;
import idx3d.idx3d_Texture;
import idx3d.idx3d_Vector;
import idx3d.idx3d_Vertex;

public class idx3d_FXLensFlare
extends idx3d_FXPlugin {
    public idx3d_Object flareObject;
    private int flares;
    private boolean zBufferSensitive = true;
    private idx3d_Texture[] flare;
    private float[] flareDist;

    public void preset1() {
        this.clear();
        this.addGlow(144, 0x330099);
        this.addStrike(320, 48, 13158);
        this.addStrike(48, 240, 0x660033);
        this.addRing(120, 0x660000);
        this.addRays(320, 32, 20, 0x111111);
        this.addSecs(12, 100, 64, 0x6633CC, 64);
    }

    private idx3d_Texture createRays(int n, int n2, int n3, int n4) {
        int n5;
        idx3d_Texture idx3d_Texture2 = new idx3d_Texture(n, n);
        int[] nArray = new int[1024];
        idx3d_Math.clearBuffer(nArray, 0);
        int n6 = 0;
        while (n6 < n2) {
            int n7 = (int)idx3d_Math.random(n3, 1023 - n3);
            n5 = n7 - n3;
            while (n5 <= n7 + n3) {
                float f = (float)(n5 - n7 + n3) / (float)(n3 * 2);
                int n8 = n5++;
                nArray[n8] = nArray[n8] + (int)(255.0 * (1.0 + Math.sin(((double)f - 0.25) * 3.14159 * 2.0)) / 2.0);
            }
            ++n6;
        }
        int n9 = n - 1;
        while (n9 >= 0) {
            n5 = n9 * n;
            int n10 = n - 1;
            while (n10 >= 0) {
                float f = (float)(2 * n10 - n) / (float)n;
                float f2 = (float)(2 * n9 - n) / (float)n;
                n6 = (int)(1023.0 * Math.atan2(f, f2) / 3.14159 / 2.0) & 0x3FF;
                int n11 = Math.max((int)(255.0f - 255.0f * idx3d_Math.pythagoras(f, f2)), 0);
                idx3d_Texture2.pixel[n10 + n5] = idx3d_Color.scale(n4, nArray[n6] * n11 / 255);
                --n10;
            }
            --n9;
        }
        return idx3d_Texture2;
    }

    private idx3d_Texture createRadialTexture(int n, int n2, int[] nArray, int[] nArray2) {
        idx3d_Texture idx3d_Texture2 = new idx3d_Texture(n, n2);
        int[] nArray3 = this.getPalette(nArray, nArray2);
        int n3 = n2 - 1;
        while (n3 >= 0) {
            int n4 = n3 * n;
            int n5 = n - 1;
            while (n5 >= 0) {
                float f = (float)(n5 - (n >> 1)) / (float)(n >> 1);
                float f2 = (float)(n3 - (n2 >> 1)) / (float)(n2 >> 1);
                idx3d_Texture2.pixel[n4 + n5] = nArray3[idx3d_Math.crop((int)(255.0 * Math.sqrt(f * f + f2 * f2)), 0, 255)];
                --n5;
            }
            --n3;
        }
        return idx3d_Texture2;
    }

    public void addSecs(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        while (n6 < n) {
            this.addFlare(this.createSec(n2, n3, n4, n5), idx3d_Math.random(-0.5f, 3.0f));
            ++n6;
        }
    }

    private idx3d_Texture createRing(int n, int n2) {
        return this.createRadialTexture(n, n, this.getColorPalette(n2, n2), this.getRingAlpha(40));
    }

    private int[] getConstantAlpha(int n) {
        int[] nArray = new int[256];
        int n2 = 255;
        do {
            nArray[n2] = n;
        } while (--n2 >= 0);
        return nArray;
    }

    public void preset3() {
        this.clear();
        this.addGlow(144, 0x993322);
        this.addStrike(400, 200, 0xCC00FF);
        this.addStrike(480, 32, 255);
        this.addRing(180, 0x990000);
        this.addRays(240, 32, 48, 0x332200);
        this.addSecs(12, 80, 64, 0x555555, 50);
        this.addSecs(12, 60, 40, 0x336699, 80);
    }

    public void addRays(int n, int n2, int n3, int n4) {
        this.addFlare(this.createRays(n, n2, n3, n4), 0.0f);
    }

    private int[] getGlowPalette(int n) {
        int[] nArray = new int[256];
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = 255;
        do {
            float f = (float)n5 / 255.0f;
            float f2 = (float)Math.cos((double)f * 1.57);
            float f3 = (float)(255.0 / Math.pow(2.718, (double)f * 2.718) - (double)((float)n5 / 16.0f));
            int n6 = (int)((float)n2 * f2 + f3);
            int n7 = (int)((float)n3 * f2 + f3);
            int n8 = (int)((float)n4 * f2 + f3);
            nArray[n5] = idx3d_Color.getCropColor(n6, n7, n8);
        } while (--n5 >= 0);
        return nArray;
    }

    private int[] getColorPalette(int n, int n2) {
        int[] nArray = new int[256];
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = n2 >> 16 & 0xFF;
        int n7 = n2 >> 8 & 0xFF;
        int n8 = n2 & 0xFF;
        int n9 = n6 - n3;
        int n10 = n7 - n4;
        int n11 = n8 - n5;
        int n12 = n3 << 8;
        int n13 = n4 << 8;
        int n14 = n5 << 8;
        int n15 = 0;
        do {
            nArray[n15] = idx3d_Color.getColor(n12 >> 8, n13 >> 8, n14 >> 8);
            n12 += n9;
            n13 += n10;
            n14 += n11;
        } while (++n15 < 256);
        return nArray;
    }

    public void addRing(int n, int n2) {
        this.addFlare(this.createRing(n, n2), 0.0f);
    }

    public void apply() {
        int n = this.flareObject.vertex[0].x;
        int n2 = this.flareObject.vertex[0].y;
        if (!this.flareObject.vertex[0].visible) {
            return;
        }
        if (this.zBufferSensitive && this.flareObject.vertex[0].z > this.scene.renderPipeline.zBuffer[n + n2 * this.screen.w]) {
            return;
        }
        int n3 = this.screen.width / 2;
        int n4 = this.screen.height / 2;
        if (this.screen.antialias()) {
            n >>= 1;
            n2 >>= 1;
        }
        float f = n3 - n;
        float f2 = n4 - n2;
        int n5 = 0;
        while (n5 < this.flares) {
            float f3 = idx3d_Math.pythagoras(f, f2) / (float)idx3d_Math.pythagoras(n3, n4);
            f3 = (1.0f - f3) / 2.0f + 1.0f;
            int n6 = this.flare[n5].width;
            int n7 = this.flare[n5].height;
            int n8 = n + (int)(f * this.flareDist[n5]);
            int n9 = n2 + (int)(f2 * this.flareDist[n5]);
            this.screen.add(this.flare[n5], n8 - n6 / 2, n9 - n7 / 2, n6, n7);
            ++n5;
        }
    }

    private void addFlare(idx3d_Texture idx3d_Texture2, float f) {
        ++this.flares;
        if (this.flares == 1) {
            this.flare = new idx3d_Texture[1];
            this.flareDist = new float[1];
        } else {
            idx3d_Texture[] idx3d_TextureArray = new idx3d_Texture[this.flares];
            System.arraycopy(this.flare, 0, idx3d_TextureArray, 0, this.flares - 1);
            this.flare = idx3d_TextureArray;
            float[] fArray = new float[this.flares];
            System.arraycopy(this.flareDist, 0, fArray, 0, this.flares - 1);
            this.flareDist = fArray;
        }
        this.flare[this.flares - 1] = idx3d_Texture2;
        this.flareDist[this.flares - 1] = f;
    }

    private int[] getLinearAlpha() {
        int[] nArray = new int[256];
        int n = 255;
        do {
            nArray[n] = 255 - n;
        } while (--n >= 0);
        return nArray;
    }

    private int[] getRingAlpha(int n) {
        int[] nArray = new int[256];
        int n2 = 0;
        do {
            nArray[n2] = 0;
        } while (++n2 < 256);
        n2 = 0;
        while (n2 < n) {
            float f = 0.01745328f * (float)(180 * n2 / n);
            nArray[255 - n + n2] = (int)(64.0 * Math.sin(f));
            ++n2;
        }
        return nArray;
    }

    private int[] getSecAlpha() {
        int[] nArray = this.getRingAlpha((int)idx3d_Math.random(0.0f, 255.0f));
        int n = 0;
        do {
            nArray[n] = nArray[n] + 255 - n >> 2;
        } while (++n < 256);
        return nArray;
    }

    private idx3d_Texture createGlow(int n, int n2, int n3, int n4) {
        return this.createRadialTexture(n, n2, this.getGlowPalette(n3), this.getConstantAlpha(n4));
    }

    public void addStrike(int n, int n2, int n3) {
        this.addFlare(this.createGlow(n, n2, n3, 48), 0.0f);
    }

    public void clear() {
        this.flares = 0;
        this.flare = null;
        this.flareDist = null;
    }

    public void addGlow(int n, int n2) {
        this.addFlare(this.createGlow(n, n, n2, 256), 0.0f);
    }

    private idx3d_Texture createSec(int n, int n2, int n3, int n4) {
        int n5 = (int)idx3d_Math.randomWithDelta(n, n2);
        int n6 = idx3d_Color.random(n3, n4);
        int n7 = idx3d_Color.random(n3, n4);
        return this.createRadialTexture(n5, n5, this.getColorPalette(n6, n7), this.getSecAlpha());
    }

    private int[] getPalette(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[256];
        int n = 255;
        do {
            int n2 = (nArray[n] >> 16 & 0xFF) * nArray2[n] >> 8;
            int n3 = (nArray[n] >> 8 & 0xFF) * nArray2[n] >> 8;
            int n4 = (nArray[n] & 0xFF) * nArray2[n] >> 8;
            nArray3[n] = idx3d_Color.getColor(n2, n3, n4);
        } while (--n >= 0);
        return nArray3;
    }

    public void preset2() {
        this.clear();
        this.addGlow(144, 0x995500);
        this.addStrike(640, 64, 0xCC0000);
        this.addStrike(32, 480, 255);
        this.addStrike(64, 329, 0x330099);
        this.addRing(160, 0x990000);
        this.addRays(320, 24, 32, 0x332211);
        this.addSecs(12, 100, 64, 0x333333, 100);
        this.addSecs(12, 60, 40, 0x336699, 80);
    }

    public void setPos(idx3d_Vector idx3d_Vector2) {
        this.flareObject.vertex[0].pos = idx3d_Vector2;
    }

    private idx3d_FXLensFlare(idx3d_Scene idx3d_Scene2) {
        super(idx3d_Scene2);
    }

    public idx3d_FXLensFlare(String string, idx3d_Scene idx3d_Scene2, boolean bl) {
        super(idx3d_Scene2);
        this.zBufferSensitive = bl;
        this.flareObject = new idx3d_Object();
        this.flareObject.addVertex(new idx3d_Vertex(1.0f, 1.0f, 1.0f));
        this.flareObject.rebuild();
        idx3d_Scene2.addObject(string, this.flareObject);
    }
}

