/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;

final class AWTSurfaceLock {
    private static final int WAIT_DELAY_MILLIS = 100;
    private final ByteBuffer lock_buffer = AWTSurfaceLock.createHandle();

    private static native ByteBuffer createHandle();

    public ByteBuffer lockAndGetHandle(Canvas canvas) throws LWJGLException {
        while (!AWTSurfaceLock.lockAndInitHandle(this.lock_buffer, canvas)) {
            LWJGLUtil.log("Could not get drawing surface info, retrying...");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LWJGLUtil.log("Interrupted while retrying: " + e);
            }
        }
        return this.lock_buffer;
    }

    private static native boolean lockAndInitHandle(ByteBuffer var0, Canvas var1) throws LWJGLException;

    protected void unlock() throws LWJGLException {
        AWTSurfaceLock.nUnlock(this.lock_buffer);
    }

    private static native void nUnlock(ByteBuffer var0) throws LWJGLException;
}

