/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.geom;

public strictfp class Vector2f {
    public float x;
    public float y;

    public Vector2f() {
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Vector2f(Vector2f other) {
        this(other.getX(), other.getY());
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Vector2f other) {
        this.set(other.getX(), other.getY());
    }

    public float dot(Vector2f other) {
        return this.x * other.getX() + this.y * other.getY();
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f negate() {
        return new Vector2f(-this.x, -this.y);
    }

    public void add(Vector2f v) {
        this.x += v.getX();
        this.y += v.getY();
    }

    public void sub(Vector2f v) {
        this.x -= v.getX();
        this.y -= v.getY();
    }

    public void scale(float a) {
        this.x *= a;
        this.y *= a;
    }

    public void normalise() {
        float l = this.length();
        this.x /= l;
        this.y /= l;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public void projectOntoUnit(Vector2f b, Vector2f result) {
        float dp = b.dot(this);
        result.x = dp * b.getX();
        result.y = dp * b.getY();
    }

    public String toString() {
        return "[Vector2f " + this.x + "," + this.y + " (" + this.length() + ")]";
    }

    public float distance(Vector2f other) {
        float dx = other.getX() - this.getX();
        float dy = other.getY() - this.getY();
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public int hashCode() {
        return (int)(this.x * this.y * 1000.0f);
    }

    public boolean equals(Object other) {
        if (other instanceof Vector2f) {
            Vector2f o = (Vector2f)other;
            return o.x == this.x && o.y == this.y;
        }
        return false;
    }
}

