/*
 * Decompiled with CFR 0.152.
 */
package owl.gameobjects;

import org.newdawn.slick.Animation;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import owl.gameobjects.Cloud;
import owl.gameobjects.Entity;

public class Owl
extends Entity {
    private boolean inAir = false;
    private SpriteSheet walkLeft;
    private SpriteSheet walkRight;
    private SpriteSheet jumpLeft;
    private SpriteSheet jumpRight;
    private SpriteSheet die;
    private int weight = 40;
    private Animation walkLeftAnim;
    private Animation walkRightAnim;
    private Animation jumpLeftAnim;
    private Animation jumpRightAnim;
    private Animation dieAnim;
    private int direction = 1;
    private boolean dead = false;
    private Cloud isStandingOn;
    private boolean started;
    private int startCounter = 1000;
    private float gravity = 8.0f;
    private int initialspeed = 200;
    private float animationSpeed = 0.5f;
    private float jumpSpeed = -5.0f;
    private float flySpeed = -0.5f;
    private int jumpCounter = 0;
    private float walkSpeed = 3.5f;

    public Owl() {
        this.setSpeedx(0.0f);
        this.setX(39.0f);
        this.setY(628.0f);
        this.setWidth(55.0f);
        this.setHeight(55.0f);
        this.setSpeedy(this.gravity);
        try {
            this.walkRight = new SpriteSheet("images/sprites/walkright.png", 66, 66);
            this.walkLeft = new SpriteSheet("images/sprites/walkleft.png", 66, 66);
            this.jumpRight = new SpriteSheet("images/sprites/jumpright.png", 66, 66);
            this.jumpLeft = new SpriteSheet("images/sprites/jumpleft.png", 66, 66);
            this.die = new SpriteSheet("images/sprites/die.png", 90, 60);
            this.walkLeftAnim = new Animation();
            this.walkLeftAnim.addFrame(this.walkLeft.getSprite(5, 0), this.initialspeed);
            this.walkLeftAnim.addFrame(this.walkLeft.getSprite(4, 0), this.initialspeed);
            this.walkLeftAnim.addFrame(this.walkLeft.getSprite(3, 0), this.initialspeed);
            this.walkLeftAnim.addFrame(this.walkLeft.getSprite(2, 0), this.initialspeed);
            this.walkLeftAnim.addFrame(this.walkLeft.getSprite(1, 0), this.initialspeed);
            this.walkLeftAnim.addFrame(this.walkLeft.getSprite(0, 0), this.initialspeed);
            this.walkRightAnim = new Animation(this.walkRight, this.initialspeed);
            this.jumpLeftAnim = new Animation();
            this.jumpLeftAnim.addFrame(this.jumpLeft.getSprite(3, 0), this.initialspeed);
            this.jumpLeftAnim.addFrame(this.jumpLeft.getSprite(2, 0), this.initialspeed);
            this.jumpLeftAnim.addFrame(this.jumpLeft.getSprite(1, 0), this.initialspeed);
            this.jumpLeftAnim.addFrame(this.jumpLeft.getSprite(0, 0), this.initialspeed);
            this.jumpRightAnim = new Animation(this.jumpRight, this.initialspeed);
            this.dieAnim = new Animation(this.die, 100);
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
        this.started = false;
        this.animation = this.jumpRightAnim;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void moveLeft() {
        if (!this.dead) {
            if (this.inAir) {
                this.isStandingOn = null;
                this.animation = this.jumpLeftAnim;
                if (this.animation.isStopped()) {
                    this.animation.start();
                }
            } else {
                this.animation = this.walkLeftAnim;
                if (this.animation.isStopped()) {
                    this.animation.start();
                }
            }
            if (this.isStandingOn == null) {
                this.setSpeedx(-this.walkSpeed);
            } else {
                this.setSpeedx(this.isStandingOn.getSpeedx() - this.walkSpeed);
            }
            this.direction = -1;
        }
    }

    public void moveRight() {
        if (!this.dead) {
            if (this.inAir) {
                this.isStandingOn = null;
                this.animation = this.jumpRightAnim;
                if (this.animation.isStopped()) {
                    this.animation.start();
                }
            } else {
                this.animation = this.walkRightAnim;
                if (this.animation.isStopped()) {
                    this.animation.start();
                }
            }
            this.setSpeedx(this.walkSpeed);
            this.direction = 1;
        }
    }

    public void stopMoving() {
        if (!this.dead) {
            if (this.isStandingOn != null) {
                this.setSpeedx(this.isStandingOn.getSpeedx());
            } else {
                this.setSpeedx(0.0f);
            }
            this.walkLeftAnim.restart();
            this.walkLeftAnim.stop();
            this.walkRightAnim.restart();
            this.walkRightAnim.stop();
        }
    }

    public void jumpOrFly() {
        if (this.inAir) {
            this.fly();
        } else {
            this.jump();
        }
    }

    private void jump() {
        if (!this.dead) {
            this.inAir = true;
            if (this.isStandingOn != null) {
                this.isStandingOn.notRaining();
            }
            this.isStandingOn = null;
            this.jumpCounter = 20;
            if (this.direction == 1) {
                this.animation = this.jumpRightAnim;
                if (this.animation.isStopped()) {
                    this.animation.start();
                }
            } else {
                this.animation = this.jumpLeftAnim;
                if (this.animation.isStopped()) {
                    this.animation.start();
                }
            }
            this.setSpeedy(this.jumpSpeed);
        }
    }

    public boolean isInAir() {
        return this.inAir;
    }

    public void die() {
        this.animation = this.dieAnim;
        this.dead = true;
        this.setSpeedx(0.0f);
        this.setSpeedy(0.0f);
    }

    private void fly() {
        if (this.direction == 1) {
            this.animation = this.jumpRightAnim;
            this.animation.setSpeed(this.animation.getSpeed() + this.animationSpeed);
        } else {
            this.animation = this.jumpLeftAnim;
            this.animation.setSpeed(this.animation.getSpeed() + this.animationSpeed);
        }
        if (this.jumpCounter < 20) {
            this.jumpCounter = this.weight < 100 ? (this.jumpCounter += 25 - this.weight / 4) : ++this.jumpCounter;
        }
        this.setSpeedy(this.flySpeed);
    }

    public void land(Cloud c) {
        this.isStandingOn = c;
        this.inAir = false;
        this.setSpeedy(0.0f);
        this.setSpeedx(c.getSpeedx());
        this.animation.stop();
        this.animation = this.direction == 1 ? this.walkRightAnim : this.walkLeftAnim;
        this.animation.stop();
    }

    @Override
    public void update(int delta) {
        if (this.started) {
            if (this.startCounter <= 0) {
                if (this.inAir) {
                    if (this.jumpRightAnim.getSpeed() > 1.0f) {
                        this.jumpRightAnim.setSpeed(this.animation.getSpeed() - 0.01f);
                    }
                    if (this.jumpLeftAnim.getSpeed() > 1.0f) {
                        this.jumpLeftAnim.setSpeed(this.animation.getSpeed() - 0.01f);
                    }
                    this.setY(this.getY() + this.getSpeedy());
                    this.setX(this.getX() + this.getSpeedx());
                    if (this.jumpCounter <= 0) {
                        this.jumpCounter = 0;
                        if (this.getSpeedy() < this.gravity) {
                            if (this.getSpeedy() + 0.2f > this.gravity) {
                                this.setSpeedy(this.gravity);
                            } else {
                                this.setSpeedy(this.getSpeedy() + 0.2f);
                            }
                        }
                    } else {
                        --this.jumpCounter;
                    }
                    if (this.getSpeedy() > 0.0f && this.isInAir() && this.isStandingOn != null) {
                        this.isStandingOn = null;
                    }
                } else {
                    this.setX(this.getX() + this.getSpeedx());
                }
                this.checkOutOfBounds();
            } else {
                if (this.startCounter < 1000) {
                    this.setY(this.getY() + -8.0f);
                    this.setX(this.getX() + 8.0f);
                    this.inAir = true;
                }
                this.startCounter -= delta;
            }
        }
    }

    public void throwOwl() {
        this.started = true;
    }

    public void fallOff() {
        this.inAir = true;
        this.isStandingOn.notRaining();
        this.isStandingOn = null;
        this.animation.stop();
        this.animation = this.direction == 1 ? this.jumpRightAnim : this.jumpLeftAnim;
        this.animation.start();
        this.setSpeedy(this.gravity);
    }

    public Cloud getIsStandingOn() {
        return this.isStandingOn;
    }

    public void checkOutOfBounds() {
        if (this.getX() <= 0.0f) {
            this.setX(0.0f);
        } else if (this.getX() >= 950.0f) {
            this.setX(949.0f);
        }
        if (this.getY() <= 66.0f) {
            this.setY(66.0f);
        }
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void eat() {
        this.weight += 2;
        this.isStandingOn.removeFood();
    }
}

