/*
 * Decompiled with CFR 0.152.
 */
package owl.gameobjects;

import org.newdawn.slick.Animation;
import org.newdawn.slick.Graphics;

public abstract class Entity {
    protected Animation animation;
    private float x;
    private float y;
    private float width;
    private float height;
    private float speedx;
    private float speedy;

    public float getSpeedx() {
        return this.speedx;
    }

    public void setSpeedx(float speedx) {
        this.speedx = speedx;
    }

    public float getSpeedy() {
        return this.speedy;
    }

    public void setSpeedy(float speedy) {
        this.speedy = speedy;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void draw(Graphics g) {
        g.translate(this.x, this.y);
        this.animation.draw(0, 0);
        g.resetTransform();
    }

    public void update(int delta) {
        this.setY(this.getY() + this.getSpeedy());
        this.setX(this.getX() + this.getSpeedx());
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public boolean collides(Entity other) {
        if (this.x > other.getX() + other.getWidth() || this.x + this.width < other.getX()) {
            return false;
        }
        return !(this.y > other.y + other.getHeight()) && !(this.y + this.height < other.getY());
    }
}

