/*
 * Decompiled with CFR 0.152.
 */
package owl.gameobjects;

import org.newdawn.slick.Animation;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.particles.ParticleSystem;
import owl.gameobjects.Entity;
import owl.gameobjects.Food;
import owl.gameobjects.Owl;

public class Cloud
extends Entity {
    private int status;
    private int difficulty;
    private static final int LIGHT = 0;
    private static final int HEAVY = 1;
    private static final int RAINY = 2;
    private int timeToRain = 10000;
    private boolean empty;
    private boolean raining;
    private Sound rainSnd;
    private Food food;
    private ParticleSystem rainParticles;

    public Cloud(float speed, int difficulty, ParticleSystem rain) {
        this.difficulty = difficulty;
        this.setSpeedx(speed);
        this.setSpeedy(0.0f);
        this.rainParticles = rain;
        try {
            this.rainSnd = new Sound("sounds/rain.wav");
        }
        catch (SlickException e1) {
            e1.printStackTrace();
        }
        this.setWidth(190.0f);
        this.setHeight(50.0f);
        this.setX(1280.0f);
        this.setY((float)(Math.random() * 200.0) + 200.0f);
        int number = (int)(Math.random() * 100.0);
        if (number <= 30) {
            this.food = new Food(this.getSpeedx(), this.getX() + 60.0f, this.getY());
        }
        float animSpeed = (float)Math.random();
        try {
            this.animation = new Animation(new SpriteSheet("images/sprites/clouds.png", 210, 93), 1000);
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
        this.animation.setSpeed(animSpeed);
        this.animation.setAutoUpdate(true);
        this.animation.start();
    }

    public boolean isRaining() {
        return this.raining;
    }

    public void notRaining() {
        this.raining = false;
        this.rainSnd.stop();
    }

    public void dissolve() {
        --this.timeToRain;
        if (this.timeToRain <= 0) {
            this.rainSnd.stop();
            this.empty = true;
        }
    }

    public boolean hasLandedOn(Owl player) {
        float tolerance;
        if (this.collides(player) && (tolerance = this.getY() - this.getHeight() - player.getY()) > -20.0f && tolerance < -5.0f) {
            this.animation.stop();
            this.rainSnd.loop(1.0f, 0.3f);
            this.raining = true;
            this.status = this.animation.getFrame();
            switch (this.status) {
                case 0: {
                    this.timeToRain = 20 * (10 - this.difficulty);
                    break;
                }
                case 1: {
                    this.timeToRain = 10 * (10 - this.difficulty);
                    break;
                }
                case 2: {
                    this.timeToRain = 3 * (10 - this.difficulty);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public void update(int delta) {
        super.update(delta);
        if (this.rainParticles != null) {
            this.rainParticles.update(delta);
            this.rainParticles.setPosition(this.getX(), this.getY() + 60.0f);
        }
        if (!this.isEmpty() && this.food != null) {
            this.food.update(delta);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (!this.isEmpty()) {
            super.draw(g);
            if (this.food != null) {
                this.food.draw(g);
            }
            if (this.isRaining()) {
                this.rainParticles.render();
            }
        }
    }

    public Food getFood() {
        return this.food;
    }

    public void removeFood() {
        this.food = null;
    }
}

