/*
 * Decompiled with CFR 0.152.
 */
package owl;

import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.Game;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.util.Log;
import owl.states.GameState;
import owl.states.InstructionsState;
import owl.states.MainMenuState;
import owl.states.ScoreState;
import owl.states.StoryState;
import owl.utils.DBHighscoreIO;
import owl.utils.HighscoreIO;

public class OwlGame
extends StateBasedGame {
    private MainMenuState menu;
    private GameState game = new GameState();
    private InstructionsState instructions = new InstructionsState();
    private StoryState story = new StoryState();
    private ScoreState score = new ScoreState();
    private HighscoreIO highscoreIO;
    private AppGameContainer container;
    private boolean fps = false;

    public OwlGame() {
        super("KN\u00d8RF, the fat owl");
    }

    public void initStatesList(GameContainer container) throws SlickException {
        if (container instanceof AppGameContainer) {
            this.container = (AppGameContainer)container;
        }
        this.menu = new MainMenuState(this);
        this.highscoreIO = new DBHighscoreIO();
        container.setShowFPS(this.fps);
        container.setVSync(true);
        container.setMouseCursor("images/icons/icon.png", 0, 0);
        container.setTargetFrameRate(60);
        this.addState((org.newdawn.slick.state.GameState)this.menu);
        this.addState((org.newdawn.slick.state.GameState)this.game);
        this.addState((org.newdawn.slick.state.GameState)this.instructions);
        this.addState((org.newdawn.slick.state.GameState)this.story);
        this.addState((org.newdawn.slick.state.GameState)this.score);
    }

    public void keyPressed(int key, char c) {
        super.keyPressed(key, c);
        if (key == 60) {
            if (this.container != null) {
                try {
                    this.container.setFullscreen(!this.container.isFullscreen());
                }
                catch (SlickException e) {
                    Log.error((Throwable)e);
                }
            }
        } else if (key == 67) {
            this.fps = !this.fps;
            this.container.setShowFPS(this.fps);
        }
    }

    public static void main(String[] argv) {
        try {
            AppGameContainer container = new AppGameContainer((Game)new OwlGame());
            container.setVerbose(false);
            container.setDisplayMode(1024, 768, false);
            container.setIcons(new String[]{"images/icons/icon.png", "images/icons/bigicon.png"});
            container.start();
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    public HighscoreIO getHighscoreIO() {
        return this.highscoreIO;
    }
}

