/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.gui;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Sound;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.gui.BasicComponent;
import org.newdawn.slick.gui.ComponentListener;
import org.newdawn.slick.gui.GUIContext;

public class MouseOverArea
extends BasicComponent {
    private static final int NORMAL = 1;
    private static final int MOUSE_DOWN = 2;
    private static final int MOUSE_OVER = 3;
    private Image normalImage;
    private Image mouseOverImage;
    private Image mouseDownImage;
    private Color normalColor = Color.white;
    private Color mouseOverColor = Color.white;
    private Color mouseDownColor = Color.white;
    private Sound mouseOverSound;
    private Sound mouseDownSound;
    private boolean mouseDown;
    private Rectangle rect;
    private Image currentImage;
    private Color currentColor;
    private ComponentListener listener;
    private boolean over;
    private int state = 1;
    private boolean mouseUp;

    public MouseOverArea(GUIContext container, Image image, int x, int y, ComponentListener listener) {
        this(container, image, x, y, image.getWidth(), image.getHeight(), listener);
    }

    public MouseOverArea(GUIContext container, Image image, int x, int y, int width, int height, ComponentListener listener) {
        super(container);
        this.normalImage = image;
        this.currentImage = image;
        this.mouseOverImage = image;
        this.mouseDownImage = image;
        this.currentColor = this.normalColor;
        this.listener = listener;
        this.rect = new Rectangle(x, y, width, height);
    }

    public void setNormalColor(Color color) {
        this.normalColor = color;
        this.updateImage(this.over);
    }

    public void setMouseOverColor(Color color) {
        this.mouseOverColor = color;
        this.updateImage(this.over);
    }

    public void setMouseDownColor(Color color) {
        this.mouseDownColor = color;
        this.updateImage(this.over);
    }

    public void setNormalImage(Image image) {
        this.normalImage = image;
        this.updateImage(this.over);
    }

    public void setMouseOverImage(Image image) {
        this.mouseOverImage = image;
        this.updateImage(this.over);
    }

    public void setMouseDownImage(Image image) {
        this.mouseDownImage = image;
        this.updateImage(this.over);
    }

    public int getWidth() {
        return (int)this.rect.width;
    }

    public int getHeight() {
        return (int)this.rect.height;
    }

    public void renderImpl(GUIContext container, Graphics g) {
        this.mouseDown = this.input.isMouseButtonDown(0);
        this.updateImage(this.rect.contains(this.input.getMouseX(), this.input.getMouseY()));
        if (this.currentImage != null) {
            int xp = (int)(this.rect.x + (this.rect.width - (float)this.currentImage.getWidth()) / 2.0f);
            int yp = (int)(this.rect.y + (this.rect.height - (float)this.currentImage.getHeight()) / 2.0f);
            this.currentImage.draw((float)xp, (float)yp, this.currentColor);
        } else {
            g.setColor(this.currentColor);
            g.fillRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
    }

    private void updateImage(boolean over) {
        this.over = over;
        if (!over) {
            this.currentImage = this.normalImage;
            this.currentColor = this.normalColor;
            this.state = 1;
            this.mouseUp = false;
        } else if (this.mouseDown) {
            if (this.state != 2 && this.mouseUp) {
                if (this.mouseDownSound != null) {
                    this.mouseDownSound.play();
                }
                this.currentImage = this.mouseDownImage;
                this.currentColor = this.mouseDownColor;
                this.state = 2;
                this.listener.componentActivated(this);
                this.mouseUp = false;
            }
        } else {
            this.mouseUp = true;
            if (this.state != 3) {
                if (this.mouseOverSound != null) {
                    this.mouseOverSound.play();
                }
                this.currentImage = this.mouseOverImage;
                this.currentColor = this.mouseOverColor;
                this.state = 3;
            }
        }
        this.mouseDown = false;
        this.state = 1;
    }

    public void setMouseOverSound(Sound sound) {
        this.mouseOverSound = sound;
    }

    public void setMouseDownSound(Sound sound) {
        this.mouseDownSound = sound;
    }
}

