/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.geom;

import org.newdawn.slick.geom.Line;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Vector2f;

public strictfp class Circle {
    public float radius;
    public float x;
    public float y;

    public Circle(float x, float y, float radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean intersects(Circle other) {
        float dy;
        float totalRad2 = this.getRadius() + other.getRadius();
        if (Math.abs(other.x - this.x) > totalRad2) {
            return false;
        }
        if (Math.abs(other.y - this.y) > totalRad2) {
            return false;
        }
        float dx = Math.abs(other.x - this.x);
        return (totalRad2 *= totalRad2) >= dx * dx + (dy = Math.abs(other.y - this.y)) * dy;
    }

    public boolean contains(float x, float y) {
        return this.intersects(new Circle(x, y, 0.0f));
    }

    public boolean intersects(Rectangle other) {
        Rectangle box = other;
        Circle circle = this;
        if (box.contains(this.x, this.y)) {
            return true;
        }
        float x1 = box.getX();
        float y1 = box.getY();
        float x2 = box.getX() + box.getWidth();
        float y2 = box.getY() + box.getHeight();
        Line[] lines = new Line[]{new Line(x1, y1, x2, y1), new Line(x2, y1, x2, y2), new Line(x2, y2, x1, y2), new Line(x1, y2, x1, y1)};
        float r2 = circle.getRadius() * circle.getRadius();
        Vector2f pos = new Vector2f(circle.getX(), circle.getY());
        for (int i = 0; i < 4; ++i) {
            float dis = lines[i].distanceSquared(pos);
            if (!(dis < r2)) continue;
            return true;
        }
        return false;
    }
}

