/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.newdawn.slick.Game;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.opengl.CursorLoader;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.ImageIOImageData;
import org.newdawn.slick.opengl.LoadableImageData;
import org.newdawn.slick.opengl.TGAImageData;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public class AppGameContainer
extends GameContainer {
    private DisplayMode originalDisplayMode = Display.getDisplayMode();
    private DisplayMode targetDisplayMode;

    public AppGameContainer(Game game) throws SlickException {
        this(game, 640, 480, false);
    }

    public AppGameContainer(Game game, int width, int height, boolean fullscreen) throws SlickException {
        super(game);
        this.setDisplayMode(width, height, fullscreen);
    }

    public void setTitle(String title) {
        Display.setTitle((String)title);
    }

    public void setDisplayMode(int width, int height, boolean fullscreen) throws SlickException {
        if (this.width == width && this.height == height && this.isFullscreen() == fullscreen) {
            return;
        }
        try {
            this.targetDisplayMode = null;
            if (fullscreen) {
                DisplayMode[] modes = Display.getAvailableDisplayModes();
                int freq = 0;
                for (int i = 0; i < modes.length; ++i) {
                    DisplayMode current = modes[i];
                    if (current.getWidth() != width || current.getHeight() != height || this.targetDisplayMode != null && current.getFrequency() < freq || this.targetDisplayMode != null && current.getBitsPerPixel() <= this.targetDisplayMode.getBitsPerPixel()) continue;
                    this.targetDisplayMode = current;
                    freq = this.targetDisplayMode.getFrequency();
                }
            } else {
                this.targetDisplayMode = new DisplayMode(width, height);
            }
            if (this.targetDisplayMode == null) {
                throw new SlickException("Failed to find value mode: " + width + "x" + height + " fs=" + fullscreen);
            }
            this.width = width;
            this.height = height;
            Display.setDisplayMode((DisplayMode)this.targetDisplayMode);
            Display.setFullscreen((boolean)fullscreen);
            if (Display.isCreated()) {
                this.initGL();
                this.enterOrtho();
            }
        }
        catch (LWJGLException e) {
            throw new SlickException("Unable to setup mode " + width + "x" + height + " fullscreen=" + fullscreen, e);
        }
        this.getDelta();
    }

    public boolean isFullscreen() {
        return Display.isFullscreen();
    }

    public void setFullscreen(boolean fullscreen) throws SlickException {
        if (this.isFullscreen() == fullscreen) {
            return;
        }
        if (!fullscreen) {
            try {
                Display.setFullscreen((boolean)fullscreen);
            }
            catch (LWJGLException e) {
                throw new SlickException("Unable to set fullscreen=" + fullscreen, e);
            }
        } else {
            this.setDisplayMode(this.width, this.height, fullscreen);
        }
        this.getDelta();
    }

    public void setMouseCursor(String ref, int hotSpotX, int hotSpotY) throws SlickException {
        try {
            Cursor cursor = CursorLoader.get().getCursor(ref, hotSpotX, hotSpotY);
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (Exception e) {
            Log.error("Failed to load and apply cursor.", e);
        }
    }

    public void setMouseCursor(ImageData data, int hotSpotX, int hotSpotY) throws SlickException {
        try {
            Cursor cursor = CursorLoader.get().getCursor(data, hotSpotX, hotSpotY);
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (Exception e) {
            Log.error("Failed to load and apply cursor.", e);
        }
    }

    public void setMouseCursor(Cursor cursor, int hotSpotX, int hotSpotY) throws SlickException {
        try {
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (Exception e) {
            Log.error("Failed to load and apply cursor.", e);
        }
    }

    public void reinit() throws SlickException {
        TextureLoader.get().clear();
        SoundStore.get().clear();
        this.initSystem();
        this.enterOrtho();
        try {
            this.game.init(this);
        }
        catch (SlickException e) {
            Log.error(e);
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SlickException {
        try {
            if (this.targetDisplayMode == null) {
                this.setDisplayMode(640, 480, false);
            }
            Display.setTitle((String)this.game.getTitle());
            Log.info("LWJGL Version: " + Sys.getVersion());
            Log.info("OriginalDisplayMode: " + this.originalDisplayMode);
            Log.info("TargetDisplayMode: " + this.targetDisplayMode);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Display.create();
                    }
                    catch (Exception e) {
                        Log.error(e);
                    }
                    return null;
                }
            });
            if (!Display.isCreated()) {
                throw new SlickException("Failed to initialise the LWJGL display");
            }
            this.initSystem();
            this.enterOrtho();
            try {
                this.getInput().initControllers();
            }
            catch (SlickException e) {
                Log.info("Controllers not available");
            }
            catch (Throwable e) {
                Log.info("Controllers not available");
            }
            try {
                this.game.init(this);
            }
            catch (SlickException e) {
                Log.error(e);
                this.running = false;
            }
            this.getDelta();
            while (this.running()) {
                int delta = this.getDelta();
                if (!Display.isVisible()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        this.updateAndRender(delta);
                    }
                    catch (SlickException e) {
                        Log.error(e);
                        this.running = false;
                        break;
                    }
                }
                this.updateFPS();
                Display.update();
                if (!Display.isCloseRequested() || !this.game.closeRequested()) continue;
                this.running = false;
            }
        }
        finally {
            AL.destroy();
            Display.destroy();
        }
        System.exit(0);
    }

    public void setIcon(String ref) throws SlickException {
        this.setIcons(new String[]{ref});
    }

    public void setMouseGrabbed(boolean grabbed) {
        Mouse.setGrabbed((boolean)grabbed);
    }

    public boolean hasFocus() {
        return Display.isVisible();
    }

    public int getScreenHeight() {
        return this.originalDisplayMode.getHeight();
    }

    public int getScreenWidth() {
        return this.originalDisplayMode.getWidth();
    }

    public void setIcons(String[] refs) throws SlickException {
        ByteBuffer[] bufs = new ByteBuffer[refs.length];
        for (int i = 0; i < refs.length; ++i) {
            LoadableImageData data;
            boolean flip = false;
            if (refs[i].endsWith(".tga")) {
                data = new TGAImageData();
            } else {
                data = new ImageIOImageData();
                flip = true;
            }
            try {
                bufs[i] = data.loadImage(ResourceLoader.getResourceAsStream(refs[i]), flip, true, null);
                continue;
            }
            catch (Exception e) {
                Log.error(e);
                throw new SlickException("Failed to set the icon");
            }
        }
        Display.setIcon((ByteBuffer[])bufs);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Display.getDisplayMode();
                }
                catch (Exception e) {
                    Log.error(e);
                }
                return null;
            }
        });
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }
}

