/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public class AngelCodeFont
implements Font {
    private Image font;
    private CharDef[] chars = new CharDef[1000];
    private int[][] kerning = new int[1000][1000];
    private int lineHeight;

    public AngelCodeFont(String fntFile, String imgFile) throws SlickException {
        this.font = new Image(imgFile, !imgFile.endsWith(".tga"));
        this.parseFnt(ResourceLoader.getResourceAsStream(fntFile));
    }

    public AngelCodeFont(String name, InputStream fntFile, InputStream imgFile, boolean isPng) throws SlickException {
        this.font = new Image(imgFile, name, isPng);
        this.parseFnt(fntFile);
    }

    private void parseFnt(InputStream fntFile) throws SlickException {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(fntFile));
            String info = in.readLine();
            String common = in.readLine();
            String page = in.readLine();
            boolean done = false;
            while (!done) {
                int offset;
                String line = in.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                if (!line.startsWith("chars c") && line.startsWith("char")) {
                    CharDef def;
                    this.chars[def.id] = def = this.parseChar(line);
                }
                if (line.startsWith("kernings c") || !line.startsWith("kerning")) continue;
                StringTokenizer tokens = new StringTokenizer(line, " =");
                tokens.nextToken();
                tokens.nextToken();
                int first = Integer.parseInt(tokens.nextToken());
                tokens.nextToken();
                int second = Integer.parseInt(tokens.nextToken());
                tokens.nextToken();
                this.kerning[first][second] = offset = Integer.parseInt(tokens.nextToken());
            }
        }
        catch (IOException e) {
            Log.error(e);
            throw new SlickException("Failed to parse font file: " + fntFile);
        }
    }

    private CharDef parseChar(String line) {
        CharDef def = new CharDef();
        StringTokenizer tokens = new StringTokenizer(line, " =");
        tokens.nextToken();
        tokens.nextToken();
        def.id = Integer.parseInt(tokens.nextToken());
        tokens.nextToken();
        def.x = Integer.parseInt(tokens.nextToken());
        tokens.nextToken();
        def.y = Integer.parseInt(tokens.nextToken());
        tokens.nextToken();
        def.width = Integer.parseInt(tokens.nextToken());
        tokens.nextToken();
        def.height = Integer.parseInt(tokens.nextToken());
        tokens.nextToken();
        def.xoffset = Integer.parseInt(tokens.nextToken());
        tokens.nextToken();
        def.yoffset = Integer.parseInt(tokens.nextToken());
        tokens.nextToken();
        def.xadvance = Integer.parseInt(tokens.nextToken());
        def.init();
        this.lineHeight = Math.max(def.height + def.yoffset, this.lineHeight);
        return def;
    }

    public void drawString(float x, float y, String text) {
        this.drawString(x, y, text, Color.white);
    }

    public void drawString(float x, float y, String text, Color col) {
        col.bind();
        for (int i = 0; i < text.length(); ++i) {
            char id = text.charAt(i);
            if (this.chars[id] == null) continue;
            this.chars[id].image.draw(x + (float)this.chars[id].xoffset, y + (float)this.chars[id].yoffset, null);
            x += (float)this.chars[id].xadvance;
            if (i >= text.length() - 1) continue;
            x += (float)this.kerning[id][text.charAt(i + 1)];
        }
    }

    public int getYOffset(String text) {
        int minYOffset = 10000;
        for (int i = 0; i < text.length(); ++i) {
            char id = text.charAt(i);
            if (this.chars[id] == null) continue;
            minYOffset = Math.min(this.chars[id].yoffset, minYOffset);
        }
        return minYOffset;
    }

    public int getHeight(String text) {
        int maxHeight = 0;
        for (int i = 0; i < text.length(); ++i) {
            char id = text.charAt(i);
            if (this.chars[id] == null) continue;
            maxHeight = Math.max(this.chars[id].height + this.chars[id].yoffset, maxHeight);
        }
        return maxHeight;
    }

    public int getWidth(String text) {
        int width = 0;
        for (int i = 0; i < text.length(); ++i) {
            char id = text.charAt(i);
            if (this.chars[id] == null) continue;
            width += this.chars[id].xadvance;
            if (i >= text.length() - 1) continue;
            width += this.kerning[id][text.charAt(i + 1)];
        }
        return width;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    private class CharDef {
        public int id;
        public int x;
        public int y;
        public int width;
        public int height;
        public int xoffset;
        public int yoffset;
        public int xadvance;
        public Image image;

        private CharDef() {
        }

        public void init() {
            this.image = AngelCodeFont.this.font.getSubImage(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return "[CharDef id=" + this.id + " x=" + this.x + " y=" + this.y + "]";
        }
    }
}

