varying vec2 texCoord;
uniform sampler2D baseMap;
uniform sampler3D noiseMap;
uniform sampler2D skyMap;
uniform samplerCube envMap;

uniform float anim;
varying vec3 norm;
varying vec3 eyeVec;
varying vec3 lightVec;
void main()
{
vec3 noiseSample = texture3D(noiseMap,vec3(texCoord,anim+texCoord.x*0.1 + texCoord.y*0.08)).xyz * 2.0 - vec3(1.0,1.0,1.0);
vec3 bumpNorm = norm;
bumpNorm.x+=noiseSample.x*0.3;
bumpNorm.z+=noiseSample.z*0.3;
bumpNorm = normalize(bumpNorm);
vec3 lightVec2=normalize(lightVec);
float lightRec = max(dot(bumpNorm,lightVec2),0.2);
float spec = clamp(dot(reflect(normalize(eyeVec),bumpNorm),normalize(lightVec2)),0.0,1.0);
spec = pow(spec,90.0);
float dist = length(eyeVec)/50.0;
spec = spec*(1.0/pow(dist,0.3));
vec3 envCol = textureCube(envMap,reflect(normalize(eyeVec),bumpNorm)).rgb;
vec4 col = texture2D(baseMap,vec2(texCoord.x+anim*1.2,texCoord.y+anim*1.3));
vec4 skyRef = texture2D(baseMap,bumpNorm.xz);
envCol = vec3(envCol.r/3.0 + envCol.g/3.0 + envCol.b/3.0);
gl_FragColor = vec4((envCol) * spec*1.0 + skyRef.rgb*0.02 ,0.99);
}