;
;  My tacky <64 byte starfield.....By Indi
;

		org $2000-2            	; -2 since we have to include a LOAD address
		dw	$2000


SCNCLR		equ	$D880				; ROM clear screen
COLOUR		equ	$053b

Delay		equ	$02
StarAdd		equ	$42



		;
		; On plus/4 reset and 1st SYS call.  A=0,X=7,Y=0,F=0  ($07f2-$07f5)			Doesn't help here.....
		; SYS command - $a7b5
		;

Start
		;
		; Init star addresses using random ROM values.
		;
		ldx	#$20
!InitAll:
		lda	$ba88,x				; create stars
		sta	StarAdd,x
		dex	
		bne	!InitAll			; Init all 32 stars

		stx	$ff15				; Black screen
		stx	$ff19				; Black border


		;
		; Process and render stars
		;
Loop2
		ldx #$20
Loop:
		dec	Delay,x				; dec movement delay
		bpl	!RenderStars		; if <0 then move star

		lda	$ba68+$20,x			; get star master delays...
		and	#$03				; only 0 to 3 please!
		sta	Delay,x				; reset delay
		dec	StarAdd,x			; move star

!RenderStars:
		lda	#$2e				; use "." as a star
		ldy	StarAdd,x			; get location
		sta	$0c00,y				; and PRINT it!
		sta	$0d00,y				; 
		sta	$0e00,y				;4 times!
		sta	$0f00,y				;
		dex
		bne	Loop				; Do all 32 stars

!lp2	ldx	$ff1d				; Execute a BIG delay so it minimises flicker as best we can
		bpl	!lp2
		LDA #$71				; clear screen with WHITE attribute
		jsr	SCNCLR	   			; kernal Clear screen 
		bne	Loop2


EndCode:
	Message "EndSize=",(EndCode-Start)



