DEBUG=0				; set to one for debug
DIRECTION=1			; 1=right, 2=left

zp_80	= $6A			; assumed value = $80
zoom	= $2E			; assumed value: any valid zoom value (>=$08)

value_x	= $FC			; fixed: used by ROM routine
value_y	= $FD

eorv	= $66			; fixed: used by ROM routine
lines	= $66			; same variable, means eorv is inited to zero after loop
		
dir	= $EE			; assumed value: $FF (or $01 would also work)
	
; start
	LDX #$33		; back color
	LDA #$6C		; fore color
	JSR clear_screen_sync
	;
il1	TXA			; create char map
	STA $0B80,x		; from $0C00, we need inverted chars ($80, $81, etc)
	INX
	BNE il1
	;
	;LDA #$FF		; A=$FF after previous loop, it's our fill byte
	LDX #$03		; number of pages (4)
	JSR fill_68		; includes sync
	;
	;			; fill pointer points to $6C00
	TYA			; A=0, X=0
	JSR fill2		; fill one more page ($6C00) with 0
	;
	;JSR sync_DC
	;
	SEC
	ROL $FF06		; screen back on
	;
	; ------------------------------------
	;
zmain	LDY #$08
	JSR sync
	;
	STY $FF07		; must reset this each time
	;
	;LAX dir
	DB $A7			; LAX $00 opcode
	DB dir
	;
	CLC
	ADC zoom		; keep changing the zoom value ("moves" the effect)
	STA zoom
	;
	JSR $EB53		; STA $FC, STA $FD, RTS
	;STA value_y		; counter for y loop
	;STA value_x
	;
	AND #$3F		; reverse at $08 and $48
	CMP #$08
	BNE no_rev
	;
	TXA			; X=dir, reverse direction
	EOR #$FE		; add value alternates between 1 (grow) and $FF (shrink)
	STA dir
	;
no_rev	; ------------------------------------
	;
	LDA #200
	STA lines
	;  
	DEY			; preload Y, Y=7
	;
	;JSR sync		; would work and would be less bytes, but the added time by the RTS shifts everything
sync1	CPY $FF1D
	BNE sync1
	;
yloop	STY $FF1F		; 4
	STY $FF1D		; keep setting the same line
	;
	LDX #$06		; normal delay
	;
	LDA $FF07		; 4
	;
	DEC value_y
	BNE no_switch		; + 8
	;
	LDX zoom		; reset value
	STX value_y
	;
	LDX #$04		; delay when switching $FF07
	;
	EOR zp_80		; EOR #$80, need to spend 1 extra cycle
	;
no_switch
d1	DEX			; this delay loop ensures vertical sync
	BNE d1      
	;
	STA $FF07,x		; index with X (X=0) to spend 1 extra cycle
	;
	DEC lines,x		; ,x = +1 cycle
	;
	BNE yloop		; (if this jumps over a 256 byte boundary, +1 cycle)
	;
	; ----------------------------------
	;
	JSR close_border	; close border, call player
	;
	if DEBUG
	DEC $FF19
	endif
	;
	if DIRECTION=1
	LDX #$F8
	else    
	LDX #$00
	endif
	;
zloop	LDA value_x		; done with 8 bits at a time
	SEC
	SBC #$08
	STA value_x		; are when done with full block?
	;
	PHP			; save C for later
	;
	BCS full_char
	;
bits	AND #$07
	TAY   
	;
	if DIRECTION=1
	LDA $D348,y		; (left) get graphics from ROM :-)
	else
	LDA $D2F8,y		; (right) get graphics from ROM :-)
	endif
	;
	DB $2C
	;
full_char
	LDA #$00		; remaining bits > 8, so limit put out full char
	;
	EOR eorv		; EOR it with our eor value, alternates color
	STA $6847,x		; draw it
	STA $6C47,x		; draw once more for inverse part of the font
	;
	PLP
	BCS skip
	;
	LDA value_x		; add back "zoom" to our counter
	;			; e.g. if we're at -1, and zoom was 10 -> value will be 9 (since 1 extra is done already)
	ADC zoom		; C=clear
	STA value_x
	;
	JSR $A62B		; LDA $66, EOR #$FF, STA $66, RTS
	;LDA eorv		; only done when on boundary of blocks
	;EOR #$FF
	;STA eorv
	;
skip	TXA
	if DIRECTION=1
	SEC
	SBC #$08		; go to next char
	else                       
	CLC
	ADC #$08		; go to next char
	endif
	TAX
	;  
	BNE zloop
	;
	if DEBUG
	INC $FF19
	endif
	;
	INC timer		; YES! Finally, it just barely fits so that
	BNE zmain		; this can be a relative jump.		
	;
	;BEQ zoom_done
	;JMP zmain
;zoom_done
;[eof]