DEBUG=0				; set to 1 for debug
DOUBLE_SIN=0			; set to 1 for double-sinus, looks better but takes more space

; contstants
height	= $90
raspos	= $10

; variables
ras_cnt	= $C4
ras_col	= $C5
sin_add	= $C6

colors	= $6800

raster_chars_width = data_raster_chars_end - data_raster_chars
raster_chars_shift = (40-raster_chars_width)/2
	;
	; ***********************
	;
	LDA #$00		; black background, black chars
	TAX
	JSR clear_screen
	;
	LDX #$1B		; screen back on
	STX $FF06		; only needed for first run, otherwise it's already on
	;  
	;LDX #$14		; starting line (counts down)
	;			; use $1B(?!) for starting line,
	;			; kills some RAM around $28xx and $A0xx, but it's ok
	;
i0	JSR $D8AA		; X = lines, get screen position in $C8/C9
	;       
	LDY #raster_chars_width + raster_chars_shift - 1
i1	LDA data_raster_chars-raster_chars_shift,y
	STA ($C8),y		; copy pattern to screen
	DEY    
	CPY #raster_chars_shift-1
	BNE i1
	;
	DEX
	BNE i0
	;
	JSR sync_DC		; this sync is sort of a waste, but otherwise
	;			; raster would "flash" in the first frame
	;
	; ---
	;
main	
	if DEBUG=1
	DEC $FF19
	endif
	;
	JSR clear_6800_6900	; erase all bars before every frame
	;
	INC $E0     
	INC $E0
	;    
	if DOUBLE_SIN=1
	DEC $E1
	DEC $E1
	DEC $E1
	;
	LDX $E1
	LDA sinus,x
	STA sin_add
	endif
	;
	LDX #data_raster_col_size
c3	STX ras_cnt
	;
raster_col_ptr
	LDA data_raster_col,x
	AND #$0F
	STA ras_col
	; 
	TXA
	ASL a
	ASL a
	ASL a
	ADC $E0
	TAX
	LDA sinus,x
	;
	if DOUBLE_SIN=1
	CLC
	ADC sin_add
	LSR a          
	endif
	;
	TAY
	LDX #data_raster_lum_size
c2	LDA data_raster_lum,x
	AND #$70			; keep lum information only
	ORA ras_col
	STA colors+2,y
	INY
	DEX
	BPL c2
	;
	LDX ras_cnt
	DEX
	BPL c3
	;
	if DEBUG=1
	INC $FF19
	endif	
	;
	; ---
	;
	LDY #raspos+1
	JSR sync
	;
	LDY #$A8		; horizontal sync position
	LDX #height                       
	;
rloop	LDA colors,x		; get the color (preload)
	;
s1	CPY $FF1E
	BCS s1			; horizontal sync
	;    
	STA $FF19		; set it to border
	STA $FF15		; ... and background = rasterbar!
	;
	DEX
	BNE rloop
	;
	; ---
	;
	JSR player_sync
	;
	INC timer
	BNE main
;[eof]