player
	LDA #$30		; both channels on
	;            
	LDX notecount		; preload note count
drum_ctrl_2
	CPX #$18
	BEQ do_drum
;drum_control_1
	CPX drum_ctrl_1		; replaced with zeropage variable
				; one cycle slower, but saves one byte for the LSR
	BNE no_drum
	;     
do_drum	LDA #$53		; set noise, + noise freq
	STA $FF0F
	STA $FF10
	;
no_drum	ORA notelen
	;JSR $B8B0		; sta $FF11, rts to slow things down (not needed)
	STA $FF11
	;
	DEC notelen
	BNE player_end
	;   
notelen_default
	LDA #$0A;notelen_default	; #$08
	STA notelen
	;
	EOR #($A^6)		; speed alternates between 10 and 6: swing tempo ;-)
	STA notelen_default +1
	;
	JSR get_next_byte	; get random byte
	AND #$03		; convert to 0-3
	;EOR #$02
	BEQ quiet		; 0 means quiet
	
;x0	LDA #$00		; debug: just loop through notes (0-2)
;	TAX
;	INX
;	CPX #$03
;	BNE x1
;	;
;	LDX #$00
;x1	STX x0+1
	;
	CLC
	ADC basecount		; add basecount, so the chords go like:
				; 1,2,3
				; 2,3,4
				; 3,4,5
				; 4,5,6
	TAY
	;
;x2	LDY #$00		; debug
;	INC x2+1
;	STA $0D00,y
	;
lead_ptr
	LDA lead1-1,y		; minus 1, because it's 1 based
	DB $2C
quiet	LDA #$FE		; $03FE: silence
	STA $FF0E
	;
	; ---
	;
	LDY basecount		; preload base note   
	;
	;LDX notecount		; note count is still in X!
	INX
	TXA
	AND #$07
	STA notecount
	;INC notecount		; just slow down base change to every 8 notes
	;LDA notecount
	;AND #$07
	BNE no_base_inc
	;
	; --- 
	;
	INY
	;
no_base_inc
	;
	TYA			; must look up base all the time because of drums
	AND #$03		; goes 0-1-2-3
	STA basecount
	TAX
	LDA base,x		; look up freq (one byte only)
	STA $FF0F
	AND #$01		; lowest bit reused as highest
	STA $FF10
	;
player_end
	RTS			; done!

	; --------------------------------------------------------
	; the bass
	;
	; freq stored on only one byte
	; lowest bit reused for highest bit
	; so
	; $07 -> $0107 (should be $0106, but the diff is negligible)
	; $40 -> $0040
	; $C5 -> $01C5
	;
	; notes are:
	;   F,  F,  C#, A#
base	DB $07,$07,$40,$C5

	; --------------------------------------------------------
	; the lead                    
	;
	; freq stored on only one byte,
	; high byte is assumed to be $03
	;
	; the notes had to be chosen so that the
	; lowest possible $03xx note is used
	;
	; the notes are chords
	; so that three consecutive notes are always ok
	; 
	; F - C - G#               : f minor
	; 
	;     C - G# - F           : f minor again
	;
	;         G# - F - C#      : c# minor
	;
	;              F - C# - A# : a# minor
	;
	;   F,  C,  G#, F,  C#, A#
lead1	DB $42,$02,$60,$42,$10,$71
	;				; lead2 is a second (higher set of notes) 
;lead2	DB $81,$A1,$B0,$A1,$88,$B8	; not used in this demo because of space 
